package graphics;

import javax.swing.JFrame;
import javax.swing.JPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Point;

/**
 * DocJava, Inc. User: lyon Date: Aug 31, 2004
 * Time: 9:41:52 AM
 */
public class Bounce extends JPanel {
    public static void main(String[] args) {
        JFrame jf = new JFrame();
        jf.setSize(200, 200);
        Container c = jf.getContentPane();
        c.add(new Bounce());
        jf.show();
    }

    // Maximum speed for line points
    private final int MAX_SPEED = 4;

    // First point on the line
    private Point p1 = new Point();

    // Second point on the line
    private Point p2 = new Point();

    // Direction of first point (vector)
    private Point dir1;

    // Direction of second point (vector)
    private Point dir2;

    // Color of line
    private Color lineColor = Color.blue;

    private void randomizePoint(Point p,
                                int width,
                                int height) {
        p.x = (int) (Math.random() * width);
        p.y = (int) (Math.random() * height);
    }

    private void bounce(Point p,
                        Point dir,
                        int width,
                        int height) {
        p.x += dir.x;
        if ((p.x < 0) || (p.x > width)) {
            p.x -= dir.x;
            if (dir.x < 0) {
                dir.x =
                        Math.abs(randomVector());
            } else {
                dir.x =
                        -Math.abs(randomVector());
            }
        }
        p.y += dir.y;
        if ((p.y < 0) || (p.y > height)) {
            p.y -= dir.y;
            if (dir.y < 0) {
                dir.y =
                        Math.abs(randomVector());
            } else {
                dir.y =
                        -Math.abs(randomVector());
            }
        }

        // If we're still out of bounds, pick a brand new point:
        if ((p.x < 0) || (p.x > width) ||
                (p.y < 0) ||
                (p.y > height)) {
            randomizePoint(p, width, height);
        }
    }

    /**
     * Returns a random number between -MAX_SPEED
     * and MAX_SPEED, inclusive, but excluding 0.
     */
    private int randomVector() {
        int result = (int) (Math.random() *
                MAX_SPEED) +
                1;
        if (Math.random() > 0.5) {
            result = -result;
        }
        return result;
    }

    public Bounce() {
        Component c = this;
        int width = c.getWidth();
        int height = c.getHeight();
        randomizePoint(p1, width, height);
        randomizePoint(p2, width, height);
        dir1 =
                new Point(randomVector(),
                        randomVector());
        dir2 =
                new Point(randomVector(),
                        randomVector());
        String colorOption = "#FF0000";
        if (colorOption != null) {
            String COLOR_FORMAT = "Color must be in #rrggbb format";
            if (colorOption.length() != 7) {
                throw new RuntimeException(COLOR_FORMAT);
            }
            try {
                int r = Integer.parseInt(colorOption.substring(1,
                        3),
                        16);
                int g = Integer.parseInt(colorOption.substring(3,
                        5),
                        16);
                int b = Integer.parseInt(colorOption.substring(5,
                        7),
                        16);
                lineColor = new Color(r, g, b);
            } catch (NumberFormatException e) {
                throw new RuntimeException(COLOR_FORMAT);
            }
        }
    }
    // for homework, make it so that bounce draws with
    // random colors
    public void paint(Graphics g) {
        Component c = this;
        int width = c.getWidth();
        int height = c.getHeight();

        // Erase old line:
        erase(g, c);

        // Move points and bounce off walls:
        bounce(p1, dir1, width, height);
        bounce(p2, dir2, width, height);

        // Draw new line:
        drawNewLine(g);
        try {
            Thread.sleep(10);
        } catch (InterruptedException e) {
            e.printStackTrace();
        }
        repaint();
    }
    // implement the selection of the random
    // colors so that they come from the
    // ColorGridCanvas.
    private Color getRandomColor() {
        return Color.cyan;
    }
    private void drawNewLine(Graphics g) {
        lineColor = getRandomColor();
        g.setColor(lineColor);
        g.drawLine(p1.x, p1.y, p2.x, p2.y);
        g.drawString("DocJava", p1.x, p1.y);
        g.drawString("DocJava", p2.x, p2.y);
    }

    private void erase(Graphics g, Component c) {
        g.setColor(c.getBackground());
        g.drawLine(p1.x, p1.y, p2.x, p2.y);
        g.drawString("DocJava", p1.x, p1.y);
        g.drawString("DocJava", p2.x, p2.y);
    }
}
