package futils;

import gui.In;
import utils.StringUtils;
import utils.SystemUtils;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;

/**
 * Copyright DocJava, inc. User: lyon
 * <p/>
 * Date: Dec 5, 2004
 * <p/>
 * Time: 9:36:58 AM
 */
public class WordPrintMerge {
    public static void main(String[] args) {
        try {
            wordPrintMerge();
        } catch (IOException e) {
            e.printStackTrace();

        }
    }


    public static void wordPrintMerge() throws IOException {
        File f =Futil.getReadFile("select a file to be merged") ;
        String fn = f.getName();
        int index =  fn.indexOf('.');
        String wild = fn.substring(index+1);
        boolean b = In.getBoolean("is "+wild+" the file suffix of interest?");
        if (!b)
          wild = In.getString("enter a suffix for a file name search");
        File files[] = Ls.getWildFiles(f,
                        wild);
        wordPrintMerge(files);

        if (In.getBoolean("Done! Want to go again?")) wordPrintMerge();
        System.exit(0);
    }

    public static void wordPrintMerge(File[] files) throws IOException {
        FileWriter fw = WriterUtil.getFileWriter("enter output file");
        PrintWriter pw = new PrintWriter(fw);
        final String directorySeparator = SystemUtils.getDirectorySeparator();

        for (int i = 0; i < files.length; i++) {
            final String str = "INCLUDE "+
                                files[i].getCanonicalPath() +
                    "" +
                    "Figure  " +
                    files[i].getName() +
                    "\r\f";
            pw.print(StringUtils.replaceAll(str, directorySeparator, ":"));
        }

        try {

            fw.close();
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void lsWordPrintMerge() {
        String wild = In.getString("enter a suffix for a file name search");

        File files[] = Ls.getWildFiles(wild);

        System.out.println(files.length + " file(s):");

        for (int i = 0; i < files.length; i++)
            System.out.println("\t" + files[i]);

    }
}
