package futils;

import java.io.File;


/** A class that contains methods for doing batch file processing
 *
 * @version 1.0
 */
public final class Ls {

    /** prevent instantiation of this class.
     */
    private Ls() {
    }


    /** prompt the user for a file and return all the directories
     * in that location
     *
     * @return An array of all the directory names
     */
    public static File[] getDirFiles() {
        return getDirFiles(
                Futil.getReadFile("select a file"));
    }

    /** given a file name, get all the directories in that location.
     *
     * @param startFile start point of a traversal of the file system
     * @return a list of all the directory names
     */
    static public File[] getDirFiles(File startFile) {
        return startFile.listFiles(new DirFilter());
    }

    /** Print the directories in a uses specified location
     */
    static public void DirsToConsole() {
        System.out.println("Ls.DirsToConsole");
        File[] dirs = getDirFiles();
        System.out.println(dirs.length + " dir(s):");
        for (int i = 0; i < dirs.length; i++)
            System.out.println("\t" + dirs[i]);
    }


    static public String[] getWildNames(File dir, String prefix, String suffix) {
        String absPath = dir.getAbsolutePath();
        String[] fileNames = dir.list(
                new WildFilter(prefix, suffix));
        String sep = System.getProperty("file.separator");
        System.out.println("getWildNames:" + absPath);
        for (int i = 0; i < fileNames.length; i++) {
            fileNames[i] = absPath + sep + fileNames[i];
        }
        return fileNames;
    }


    public static void testGetWildFiles() {
        File f[] = getWildFiles(
                Futil.getReadDirFile(
                        "select a class directory"), "class");
        System.out.println("f.length=" + f.length);
        print(f);
    }

    static public String[] getWildNames(String prefix,
                                        String suffix) {
        File dir = Futil.getReadFile("select a file");
        return getWildNames(dir, prefix, suffix);
    }

    static public void wildToConsole(String wild) {
        File files[] = getWildFiles(wild);
        System.out.println(files.length + " file(s):");
        for (int i = 0; i < files.length; i++)
            System.out.println("\t" + files[i]);

    }


    /** print an array of objects to the console
     *
     * @param o an array of objects
     */
    public static void print(Object o[]) {
        for (int i = 0; i < o.length; i++)
            System.out.println(o[i]);
    }

    static public void listFilesToConsole(String suffix) {

        File dirFile = Futil.getReadFile("select a file");
        String[] files = dirFile.list(new WildFilter(suffix));
        System.out.println(files.length + " file(s):");
        for (int i = 0; i < files.length; i++)
            System.out.println("\t" + files[i]);
    }

    static public void deleteWildFiles(String wild) {
        File[] files = getWildFiles(wild);
        System.out.println(files.length + " file(s):");
        for (int i = 0; i < files.length; i++)
            deleteFile(files[i]);
    }

    static public void deleteFile(File f) {

        System.out.print("deleting file " + f);
        if (f.exists()) {
            System.out.println(" deleted!");
            f.delete();
        } else
            System.out.println(" does not exist");
    }

    /**
     * gets all the files that end with a PICT suffix
     * and creates a WORD print merge command that will include the pict files.
     */

    public static void wordPrintMerge() {
        String wild = "";
        String wordString =
                ".	INCLUDE hd:current:Java book:chapter I:batch 1 rev1:picts:";
        File files[] = getWildFiles(wild);
        System.out.println(files.length + " file(s):");
        int fileNumber;
        for (int i = 0; i < files.length; i++) {
            fileNumber = i + 1;
            System.out.print("Figure *." +
                    fileNumber +
                    wordString);
            System.out.println(files[i] + "");
        }
    }




    static public File[] getDirs(File dir) {
        return dir.listFiles(new DirFilter());
    }


    public static File[] getWildFiles(String suffix) {
        return getWildFiles(Futil.getReadFile("select a file"),
                suffix);
    }

    static public File[] getWildFiles(File directory, String suffix) {
        String absPath = directory.getAbsolutePath();
        if (directory.isFile()) {
            directory = directory.getParentFile();
        }
        return directory.listFiles(new WildFilter(suffix));
    }


    static public void toConsole() {

        File dirFile = Futil.getReadDirFile("select a file");
        String[] files = dirFile.list(new FileFilter());
        System.out.println(files.length + " file(s):");
        for (int i = 0; i < files.length; i++)
            System.out.println("\t" + files[i]);
    }


    /** "@param args
     */
    public static void main(String args[]) {
        testGetWildFiles();
    }
}
