package futils;

import javax.swing.JDialog;
import javax.swing.JLabel;
import java.awt.Container;
import java.awt.FlowLayout;
import java.io.File;
import java.io.FilenameFilter;
import java.util.Collections;
import java.util.Vector;

/**
 * DirList, w/o recursion.
 */
public class DirList {
    private File startDir;
    private Vector history = new Vector();
    private int totalBytes = 0;
    private String suffix = null;
    private boolean verbose = false;
    private ProgressPanel pp = new ProgressPanel();
    private FilenameFilter fnf = null;

    public class ProgressPanel extends JDialog {
        JLabel jl = new JLabel("file #");
        JLabel fl = new JLabel("0");
        int i = 0;

        ProgressPanel() {
            Container c = getContentPane();
            c.setLayout(new FlowLayout());
            c.add(jl);
            c.add(fl);
            setSize(200, 200);
        }

        public void incrementValue() {
            fl.setText("" + i++);
        }
    }

    public static void main(String args[]) {
        DirList dl = new DirList("");
        dl.sort();
        File f[] = dl.getFiles();
        dl.printFiles();
        dl.printStats();
    }

    public void sort() {
        Collections.sort(history);
    }

    public DirList(FilenameFilter fnf) {
        this.fnf = fnf;
        suffix = null;
        startDir = Futil.getReadDirFile("select a directory");
        pp.show();
        startAtThisDir(startDir);
        pp.hide();
    }

    public DirList(String _suffix) {
        suffix = _suffix;
        startDir = Futil.getReadDirFile("select a *." + suffix + " file");
        pp.show();
        startAtThisDir(startDir);
        pp.hide();
    }

    public DirList(File _startDir, String _suffix) {
        startDir = _startDir;
        startAtThisDir(startDir);
    }

    public void printStats() {
        System.out.println("Saw " +
                getTotalFiles() +
                " *" +
                suffix +
                " files with a total size of " +
                totalBytes +
                " bytes");
    }

    public void printFiles() {
        System.out.println("PrintFiles-------");
        File f[] = getFilesNotDirectories();
        for (int i = 0; i < f.length; i++)
            System.out.println(f[i]);
    }

    public final void printVerbose(Object o) {
        if (verbose)
            System.out.println(o);
    }

    //-------------------------------------------------------
    // Recursive function that given an anchor directory
    // will walk directory gui.tree
    //
    //-------------------------------------------------------
    public void startAtThisDir(File f1) {
        printVerbose("Selected -> " + f1);
        printVerbose("Files in this Directory: ");
        addFilesInThisDirectory(f1);
        processAllDirectoriesInThisDirectory(f1);
    }

    private Vector vecDir = new Vector();

    private File nextDir() {
        return (File) vecDir.remove(vecDir.size() - 1);
    }

    private void addDirs(File dirList[]) {
        if (dirList == null) return;
        for (int i = 0; i < dirList.length; i++)
            vecDir.addElement(dirList[i]);
    }

    private void processAllDirectoriesInThisDirectory(File f1) {
        addDirs(f1.listFiles(new DirFilter()));
        while (vecDir.size() > 0) {
            File f = nextDir();
            printVerbose("Selected -> " + f);
            printVerbose("Files in this Directory: ");
            addFilesInThisDirectory(f);
            addDirs(f.listFiles(new DirFilter()));
        }
    }

    //-------------------------------------------------------
    // Loop through all the filenames in the current directory
    // and store them in history:
    //-------------------------------------------------------
    private void addFilesInThisDirectory(File f1) {
        File ls[] = null;
        pp.incrementValue();
        if (fnf == null)  {
             ls = f1.listFiles(new WildFilter(suffix));
        } else  ls = f1.listFiles(fnf);
        if (ls == null) return;
        for (int i = 0; i < ls.length; i++)
            addFile(ls[i]);
    }

    private void addFile(File f2) {
        int bytes = Futil.available(f2);
        totalBytes += bytes;
        printVerbose(f2 +
                " has " +
                bytes + " bytes");
        history.addElement(f2);
    }

    public File getStartDir() {
        return startDir;
    }

    public File[] getFilesNotDirectories() {
        Vector v = new Vector();
        for (int i = 0; i < history.size(); i++) {
            File f = (File) history.elementAt(i);
            if (f.isFile())
                v.addElement(f);
        }
        File f[] = new File[v.size()];
        v.copyInto(f);
        return f;
    }

    public File[] getFiles() {
        File f[] = new File[history.size()];
        history.copyInto(f);
        return f;
    }

    public int getTotalBytes() {
        return totalBytes;
    }

    public int getTotalFiles() {
        return history.size();
    }

    public String getSuffix() {
        return suffix;
    }
}



