package classUtils.reflection;

import collections.sortable.SortableVector;
import security.WebStartBean;
import utils.StringUtils;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

/**
 * methodList is a container and processor of methods.
 */
public class MethodList {
    private java.util.Vector v = new java.util.Vector();

    public MethodList(Class c) {
        java.lang.reflect.Method ma[] = c.getMethods();
        for (int i = 0; i < ma.length; i++)
            if (ma[i].getDeclaringClass() != Object.class)
                v.addElement(ma[i]);
    }
    public boolean hasMainMethod() {
        Method m[] = getMainMethods();
        return m.length != 0;
    }
    /**
       * Get a list of all methods that might be
       * considered a main method
       *
       * @return method list
       */
      public Method[] getMainMethods() {
          Method allMethods[] = getMethods();
          Vector mainMethods = new Vector();
          for (int i = 0;
               i < allMethods.length;
               i++) {
              Method m = allMethods[i];
              String methodString = m.toString();
              if ((-1 ==
                   methodString.indexOf("public"))) continue;
              if ((-1 ==
                   methodString.indexOf("static"))) continue;

              if (!m.getName().equals("main")) continue;

              String returnType = m.getReturnType()
                      .toString();
              if (!returnType.equals("void")) continue;
              Class params[] = m.getParameterTypes();
              if (params.length != 1) continue;
              Class firstParam = params[0];
              String args[] = {"hi", "there"};
              Class argsArray = args.getClass();
              if (!argsArray.toString().equals(
                      "class [Ljava.lang.String;"))
                  continue;
              mainMethods.addElement(m);
          }
          Method ma[] = new Method[mainMethods.size()];
          mainMethods.copyInto(ma);
          return ma;
      }

    public static void main(String[] args) {
        WebStartBean wsb = WebStartBean.getDefaultWebStartBean();
        MethodList ml = new MethodList(wsb.getClass());
        Method m[] = ml.getReadWriteMethods();
        for (int i = 0; i < m.length; i++)
            System.out.println(m[i]);
    }

    public MethodList() {
    }

    /**
     * @param setter - given the <code>setter </code>
     * @return the <code>getter</code>.
     */
    public Method getReadMethod(Method setter) {
        String propertyName = getPropertyName(setter);
        Method ma[] = getReadMethods();
        for (int i = 0; i < ma.length; i++)
            if (propertyName.equals(getPropertyName(ma[i]))) return ma[i];
        return null;
    }

    public static Method[] getPrimMethods(MethodList ml) {
        Method m[] = ml.getWriteMethods();
        Vector v = new Vector();
        for (int i = 0; i < m.length; i++) {
            Method m1 = m[i];
            if (isAcceptableParamList(m1))
                v.addElement(m1);
        }
        Method newArray[] = new Method[v.size()];
        v.copyInto(newArray);
        return newArray;
    }

    public int index(java.lang.reflect.Method m1) {
        for (int i = 0; i < v.size(); i++) {
            java.lang.reflect.Method m2 = elementAt(i);
            if (equals(m1, m2))
                return i;
        }
        return -1;
    }

    public static boolean isAcceptableParamList(Method m) {
        Class c[] = m.getParameterTypes();
        for (int i = 0; i < c.length; i++) {
            if ((!c[i].isPrimitive()) &&
                    (!c[i].equals(String.class)))
                return false;
        }
        return true;
    }
    // How would you build a CLI for a method
    // that takes arguments?
    // For example:
    // run() is different from run(arg1, arg2);
    // 1. Extract the method name.
    // 2. Extract the arguments.
    // public void run();
    // public void run(String s1, String s2);
    // It is clear that:
    // run(arg1, arg2) -> public void run(String s1, String s2)
    // public void run(int i1, int i2);
    // parse(String commandLine) ....
    // parse("run(12,13)");
    // PR1 - Method name preceedes ()'s.
    // PR2 - Args are in ()'s.
    // String args[] = {"12","13"};
    // Args always come from the command line so
    // main can always be invoked!

    java.lang.reflect.Method[] getMethodsWithNArgs(int n) {
        java.lang.reflect.Method m[] = getMethods();
        return getMethodsWithNArgs(m, n);
    }

    public static Method[] getMethodsWithNArgs(Method[] m, int n) {
        MethodList ml = new MethodList();
        for (int i = 0; i < m.length; i++) {
            Class ca[] = m[i].getParameterTypes();
            if (ca.length == n)
                ml.add(m[i]);
        }
        return ml.getMethods();
    }

    public String[] getPropertyNames() {
        Method m[] = getWriteMethods();
        SortableVector v = new SortableVector();
        for (int i = 0; i < m.length; i++) {
            v.addElement(getPropertyName(m[i]));
        }
        v.sort();
        String s[] = new String[m.length];
        v.copyInto(s);
        return s;
    }

    public static String getPropertyName(Method m) {
        String s = m.getName();
        if (s.startsWith("set") || s.startsWith("get"))
            s = s.substring(3);
        else if (s.startsWith("is"))
            s = s.substring(2);
        StringBuffer sb = StringUtils.LowerCaseFirstLetter(s);
        return sb.toString();
    }

    /**
     * return true if input method
     * has a corresponding read method.
     *
     * @param m The input method
     * @return true if read method present.
     */
    public boolean hasReadMethod(Method m) {
        Method ma[] = getReadMethods();
        String s = getPropertyName(m);
        for (int i = 0; i < ma.length; i++) {
            if (s.equals(getPropertyName(ma[i]))) return true;
        }
        return false;
    }

    public java.lang.reflect.Method[] getReadWriteMethods() {
        java.lang.reflect.Method m[] = getMethods();
        MethodList ml = new MethodList();
        for (int i = 0; i < m.length; i++) {
            String s = m[i].getName();
            if (s.startsWith("set"))
                if (hasReadMethod(m[i]))
                    ml.add(m[i]);
        }
        return ml.getMethods();
    }

    public java.lang.reflect.Method[] getWriteMethods() {
        java.lang.reflect.Method m[] = getMethods();
        MethodList ml = new MethodList();
        for (int i = 0; i < m.length; i++) {
            String s = m[i].getName();
            if (s.startsWith("set"))
                ml.add(m[i]);
        }
        return ml.getMethods();
    }

    public java.lang.reflect.Method[] getAllPublicStaticMethods() {
        java.lang.reflect.Method m[] = getAllPublicMethods();
        MethodList ml = new MethodList();
        for (int i = 0; i < m.length; i++) {
            String s = m[i].toString();
            if (s.indexOf("static") != -1)
                ml.add(m[i]);
        }
        return ml.getMethods();
    }



    public java.lang.reflect.Method[] getAllPublicMethods() {
        java.lang.reflect.Method m[] = getMethods();
        return getPublicMethods(m);
    }
    public Method[] getPublicReadMethods() {
        return getPublicMethods(getReadMethods()) ;
    }
    public static Method[] getPublicMethods(Method[] m) {
        MethodList ml = new MethodList();
        for (int i = 0; i < m.length; i++) {
            String s = m[i].toString();
            if (s.startsWith("public"))
                ml.add(m[i]);
        }
        return ml.getMethods();
    }

    public java.lang.reflect.Method[] getReadMethods() {
        java.lang.reflect.Method m[] = getMethods();
        MethodList ml = new MethodList();
        for (int i = 0; i < m.length; i++) {
            String s = m[i].getName();
            if (s.startsWith("get") || s.startsWith("is"))
                ml.add(m[i]);
        }
        return ml.getMethods();
    }

    public boolean containedBy(java.lang.reflect.Method m) {
        if (index(m) == -1) return false;
        return true;
    }

    /**
     * turn a <code>Vector</code> of methods into an array of methods
     */
    private static java.lang.reflect.Method[]
            getMethods(java.util.Vector vm) {
        java.lang.reflect.Method ma[] =
                new java.lang.reflect.Method[vm.size()];
        vm.copyInto(ma);
        return ma;
    }

    public Class[] getReturnTypes() {
        Method m[] = getMethods();
        Class ca[] = new Class[m.length];
        for (int i = 0; i < m.length; i++)
            ca[i] = m[i].getReturnType();
        return ca;
    }

    /**
     * return the internally held data as an array of methods;
     */
    public java.lang.reflect.Method[] getMethods() {
        return getMethods(v);
    }

    /**
     * Return all the methods in the array that
     * are not contained in the method list.
     */
    public java.lang.reflect.Method[]
            filter(java.lang.reflect.Method m[]) {
        MethodList ml = new MethodList();
        for (int i = 0; i < m.length; i++) {
            java.lang.reflect.Method u = m[i];
            if (!containedBy(u))
                ml.add(u);
            else
                System.out.println("// removed:" + u);
        }
        return ml.getMethods();
    }

    /**
     * get number of methods in list
     */
    public int size() {
        return v.size();
    }

    public java.lang.reflect.Method elementAt(int i) {
        return (java.lang.reflect.Method) v.elementAt(i);
    }

    public void add(java.lang.reflect.Method m) {
        v.addElement(m);
    }

    public void add(java.lang.reflect.Method m[]) {
        for (int i = 0; i < m.length; i++)
            v.addElement(m[i]);
    }

    /**
     * determine if two methods are equal.
     * If they are non-null, have the same names
     * and parameter lists, then they are equal.
     */
    public static boolean equals(java.lang.reflect.Method m1,
                                 java.lang.reflect.Method m2) {
        if (m1 == null)
            return false;
        if (m2 == null)
            return false;
        if (!m1.getName().equals(m2.getName()))
            return false;
        Class[] p1 = m1.getParameterTypes();
        Class[] p2 = m2.getParameterTypes();
        if (p1.length != p2.length)
            return false;
        for (int i = 0; i < p1.length; i++)
            if (p1[i] != p2[i])
                return false;
        return true;
    }

    public static boolean hasPublicTransientProperty(Class c, Method m) {
        try {
            System.out.println("checking:" + m.getName());
            String name = getPropertyName(m);
            System.out.println("prop:" + name);
            // only returns public fields!
            Field f = c.getField(name);
            boolean aTransient = Modifier.isTransient(f.getModifiers());
            System.out.println("isTransient=" + aTransient);
            return aTransient;
        } catch (NoSuchFieldException e) {
            return false;
        }
    }

    public static boolean hasPasswordProperty(Method m) {
        String name = getPropertyName(m);
        return name.endsWith("password");
    }
}