package classUtils.reflection;

import classUtils.dumper.ClassFile;
import gui.In;

/**
 * This class uses the command pattern to
 * implement a button.
 *
 * @author D. Lyon
 * @version 1.0
 */
public class Command
        implements
        java.awt.event.ActionListener,
        Runnable {
    private javax.swing.AbstractButton ab;

    public Command(javax.swing.AbstractButton _ab) {
        ab = _ab;
        ab.addActionListener(this);
    }

    public javax.swing.AbstractButton getButton() {
        return ab;
    }

    public void actionPerformed(java.awt.event.ActionEvent e) {
        run();
    }

    public void run() {
    }

    public static Class getClassFromFile() {
        ClassFile cf = null;
        try {
            cf = ClassFile.getClassFile();
        } catch (Exception e) {
            return getClassFromFile();
        }
        return getClass(cf.getClassName());
    }

    public static void promptUserForClassName()
            throws ClassNotFoundException,
            IllegalAccessException,
            InstantiationException {
        String cn = In.getString("enter a class name");
        Class c = Class.forName(cn);
        In.message(c.newInstance().toString());
    }

    public static Class getClass(String className) {
        try {
            return Class.forName(className);
        } catch (ClassNotFoundException e) {
            In.message(e);
        }
        return null;
    }

    public static void main(String[] args) {
        try {
            for (; ;)
                promptUserForClassName();
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InstantiationException e) {
            e.printStackTrace();
        }
    }
}