package classUtils.putils;

import gui.dialogs.BeanDialog;

/**
 * Copyright DocJava, inc. User: lyon Date: Sep 6,
 * 2004 Time: 10:25:51 AM
 */
public class ClassPathBean {
    private String classPaths[] = ClassPathUtils.getClassPaths();
    private String pathSeparator = System.getProperty(
            "path.separator");

    public ClassPathBean() {
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0;
             i < classPaths.length;
             i++) {
            sb.append(classPaths[i]);
            sb.append(pathSeparator);
        }
        return sb.toString();
    }

    public static void main(String[] args) {
        ClassPathBean cpb = getClassPathBeanGui();
        System.out.println(cpb);
    }

    public static ClassPathBean getClassPathBeanGui() {
        ClassPathBean cpb = new ClassPathBean();
        BeanDialog bd = new BeanDialog(cpb);
        bd.setSize(500, 500);
        bd.show();
        return (ClassPathBean) bd.getData();
    }

    public String[] getClassPath() {
        return classPaths;
    }

    public void setClassPath(String classPaths[]) {
        this.classPaths = classPaths;
    }
}
