/**
 *
 * @author D. Lyon
 * @version 1.0
 * Date: Apr 1, 2002
 * Time: 2:39:17 PM
 */
package classUtils.putils;

import classUtils.reflection.ReflectUtil;

import java.util.Arrays;
import java.util.Comparator;
import java.util.Vector;

public class ClassList {
    private Vector v = new Vector();

    public Vector getVector() {
        return v;
    }

    public void add(Class c) {
        v.addElement(c);
    }

    public void add(Class c[]) {
        for (int i = 0; i < c.length; i++)
            add(c[i]);
    }

    public static void sort(Class ca[]) {
        Arrays.sort(ca,
                new ClassComparator()
        );
    }

    private static class ClassComparator implements Comparator {
        public int compare(Object a, Object b) {
            return ((Class) a).getName().compareTo(
                    ((Class) b).getName());
        }
    }

    public static void main(String args[]) {
        Package p = Package.getPackage("java.lang");
        System.out.println(p);
    }


    public int getNumberOfMethods() {
        Class ca[] = getClasses();
        int n = 0;
        for (int i = 0; i < ca.length; i++) {
            ReflectUtil ru =
                    new ReflectUtil(ca[i]);
            n = n + ru.getMethods().length;
        }
        return n;
    }

    public Class[] getClasses() {
        Class ca[] = new Class[v.size()];
        v.copyInto(ca);
        return ca;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < v.size(); i++)
            sb.append(v.elementAt(i) + "");
        return sb.toString();
    }

    public void print() {
        for (int i = 0; i < v.size(); i++)
            System.out.println(v.elementAt(i));
        System.out.println("printed "
                + v.size() + " classes");
    }

    public int getSize() {
        return v.size();
    }
}
