package classUtils.pack.util.jdbc;

import java.net.InetAddress;

/**
 * JdbcURLs for Microsoft MS SQL 2000.
 * <p>
 * The outer (abstract) class just defines the port to be 1432 and declares 
 * <tt>public</tt> the proper setters.
 * <p>
 * The inner classes declare the proper template for some known drivers.
 * 
 * @author Cristiano Sadun
 */
public abstract class MSSQLJdbcURL extends JdbcURL {

	/**
	 * A JDBC url template for the Avenir CaveConnect drivers
	 * for MS SQL 2000.
	 * <p>
	 * The template has the form <tt>jdbc:AvenirDriver://$(host):$(port)/$(database);uid=$(user);pwd=$(password)</tt>.
	 */	
	public static class AvenirURL extends MSSQLJdbcURL {

		/**
		 * Constructor for AvenirDriverJDBCURL.
		 * @param template
		 */
		public AvenirURL() {
			super("jdbc:AvenirDriver://$(host):$(port)/$(database);uid=$(user);pwd=$(password)");
		}
	}

	/**
	 * Constructor for MSSQLJdbcURL.
	 * @param template
	 */
	public MSSQLJdbcURL(String template) {
		super(template);
		setPort(1432);
	}
	
	/**
	 * @see classUtils.pack.util.jdbc.JdbcURL#setDatabase(String)
	 */
	public void setDatabase(String database) {
		super.setDatabase(database);
	}

	/**
	 * @see classUtils.pack.util.jdbc.JdbcURL#setHost(InetAddress)
	 */
	public void setHost(InetAddress host) {
		super.setHost(host);
	}

	/**
	 * @see classUtils.pack.util.jdbc.JdbcURL#setPassword(String)
	 */
	public void setPassword(String password) {
		super.setPassword(password);
	}

	/**
	 * @see classUtils.pack.util.jdbc.JdbcURL#setPort(int)
	 */
	public void setPort(int port) {
		super.setPort(port);
	}

	/**
	 * @see classUtils.pack.util.jdbc.JdbcURL#setPort(String)
	 */
	public void setPort(String port) {
		super.setPort(port);
	}

	/**
	 * @see classUtils.pack.util.jdbc.JdbcURL#setUser(String)
	 */
	public void setUser(String username) {
		super.setUser(username);
	}

}
