package classUtils.pack.util;

import java.io.*;
import java.util.*;

public class PushbackReader extends FilterReader {

    private ArrayList buf;

    public PushbackReader(Reader r) {
        this(r,1);
    }

    public PushbackReader(Reader r, int windowSize) {
        super(r);
        this.buf=new ArrayList();
    }

    public int read() throws IOException {
        int size=buf.size();
        if (size==0) return super.read();
        else {
            return ((Integer)buf.remove(buf.size()-1)).intValue();
        }
    }

    public void unread(int c) throws IOException {
        buf.add(new Integer(c));
    }

    private static void readAll(Reader r) throws IOException {
        int c;
        while((c=r.read())!=-1) System.out.print((char)c);
        System.out.println();
    }

    public static void main(String args[]) throws Exception {
        PushbackReader r = new PushbackReader(new StringReader("ciao"));
        readAll(r);
        r.unread('a');
        r.unread('i');
        r.unread('c');

        //r.unread('o');
        readAll(r);
    }
}