package classUtils.pack.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;


/**
 * An utility class to compute normalized paths (i.e. paths that do not contain
 * neither "." nor "..")
 *
 * @author C. Sadun
 * @version 1.0
 */
public class PathNormalizer {

    /**
     * Normalizes a file object. The returned file object will
     * return the normalize path when File.getAbsolutePath() is invoked.
     * @param path the File object to be normalized
     * @return a File object whose absolute path name is normalized
     */
    public static File normalize(File path) {
        return new File(normalizePath(path.getAbsolutePath()));
    }

    /**
     * Normalizes a string path. The returned path does not
     * contain ".." or "." references
     * @param path the path to be normalized.
     * @return a String object containing the normalized path
     */
    public static String normalizePath(String path) {
        File f = new File(path);
        boolean trailingFSep=path.endsWith(File.separator);
        path=f.getAbsolutePath();
        StringTokenizer st = new StringTokenizer(path, File.separator);
        List names=new ArrayList();
        while(st.hasMoreTokens()) {
            String step = st.nextToken();
            if (".".equals(step)) continue;
            else if ("..".equals(step)) names.remove(names.size()-1);
            else names.add(step);
        }

        StringBuffer sb = new StringBuffer();
        for(Iterator i=names.iterator(); i.hasNext(); ) {
            sb.append(i.next());
            if (i.hasNext()) sb.append(File.separator);
        }
        if (trailingFSep)
           sb.append(File.separator);
        return sb.toString();
    }

}