package classUtils.pack;

import classUtils.putils.ClassPathUtils;
import classUtils.reflection.Command;
import classUtils.pack.util.ant.Pack;
import futils.Futil;




/**
 * User: lyon Date: May 18, 2004 Time: 10:38:11
 * AM
 */
public class DependencyUtils {
    public static void main(String[] args) {
        Class classFromFile = Command.getClassFromFile();
        printDependencies(classFromFile);
    }

    private static void packTask() {
        pack(dhry.Main.class);
        pack(addBk.addressBook.Main.class);
        pack(classUtils.pack.DependencyUtils.class);
        pack(ip.Main.class);
    }

    public static void pack(Class c) {
        String name = c.getName();
        pack(name, name + ".jar");
    }

    public static void printDependencies(Class mainClass) {
        String name1 = mainClass.getName();
        Pack p1 = new Pack();
        p1.setManifestMainClass(name1);
        p1.setClasses(name1);
        p1.setTargetJar(name1 + ".jar");
        p1.execute();
        p1.printDependencies();

    }

    public static void pack(String mainClass,
                            String targetJar) {
        Pack p = new Pack();
        p.setManifestMainClass(mainClass);
        p.setClasses(mainClass);
        p.setTargetJar(targetJar);
        final String classPath =
                ClassPathUtils.getClassPath();
        System.out.println("using class path:" + classPath);
        p.setClasspath(classPath);
        p.execute();
        System.out.println("done with:" + targetJar);
    }
}
