package classUtils.loaders;

// distClasses.Reloader

//package net.compute;

/**
 * Created by
 * User: lyon
 * Date: Sep 3, 2003
 * Time: 11:17:45 AM
 *
 */

import futils.DirList;
import utils.StringUtils;

import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Vector;

// Due 11/5/03:
// Prompt the user for the class directory.
// Scan the directory and sub-directories for all the classes.
// Return and print
// all the classes that implement ComputableObject.

// For the midterm  Due 11/19/03
// Ask the user, using a Swing GUI, which computableObjects get deployed.
// Use a given remote machine to deploy and compute the object.
// Seriazable ans = Compute(ComputableObject co, String machineNameOrAddress);
// System.out.println(ans);
//


/**
 * Use the reloader to get the bytecode from
 * a file for a class. Then, transmit the class byte
 * codes to the computation server. Use the
 * Reloader on the computation server to define the
 * class. Then compute the computation.
 * Send the answer back to the compute client.
 * Finally, set the remote reloader to null and
 * close the connections.
 */

public class Reloader extends ClassLoader {

    private String classPath;

    public Reloader() {
        DirList dl = new DirList(".class");
        classPath = dl.getStartDir().toString();
        System.out.println("classPath" + classPath);
        File f[] = dl.getFiles();
        //dl.printFiles();
        //print(loadClasses(getClassNames(f)));
    }

    public static Class[] loadClasses(String classNames[]) {
        Class[] ca = new Class[classNames.length];
        for (int i = 0; i < ca.length; i++) {
            try {
                ca[i] = Class.forName(classNames[i]);
            } catch (ClassNotFoundException e) {
                System.out.println("classNotFound:" + classNames[i]);
            }
        }
        return ca;
    }

    public static void print(Object o[]) {
        for (int i = 0; i < o.length; i++)
            System.out.println(o[i]);
    }

    public String[] getClassNames(File f[]) {
        Vector v = new Vector();
        for (int i = 0; i < f.length; i++) {
            String s = f[i].toString();
            v.addElement(makeClassString(s));
        }
        String cn[] = new String[v.size()];
        v.copyInto(cn);
        return cn;
    }

    public static char getClassPathSeparator() {
        String s = System.getProperty("file.separator");
        return s.charAt(0);
    }

    public String makeClassString(String s) {
        char c = getClassPathSeparator();
        s = StringUtils.sub(s, classPath + c, "");
        s = StringUtils.sub(s, ".class", "");
        s = s.replace(c, '.');
        return s;
    }

    public static void main(String args[]) {
        Reloader rl = new Reloader();
    }

    public Reloader(String classPath) {
        this.classPath = classPath;
    }

    public void defineClass(byte b[], String className) {
        super.defineClass(className, b, 0, b.length);
    }

    public synchronized Class loadClass(String className,
                                        boolean resolveIt)
            throws ClassNotFoundException {

        Class result;
        byte classData[];

        // Check the loaded class cache
        result = findLoadedClass(className);
        if (result != null) {
            // Return a cached class
            System.out.println("The class has already been loaded");
            return result;
        }

        // If Spoofed, don't delegate
        // result is 0 if strings are equal.
        if (className.compareTo("Spoofed") != 0) {

            // Check with the system class loader
            try {
                return loadWithSystemClassLoader(className);
            } catch (ClassNotFoundException e) {
                System.out.println("unable to load with system class loader...");
            }
        }

        // Don't attempt to load a system file except through
        // the primordial class loader
        // for example, java.lang.String
        if (className.startsWith("java.")) {
            throw new ClassNotFoundException();
        }

        // Try to load it from the classPath directory.
        classData = getByteCodes(className);
        System.out.println("classData has " + classData.length + " bytes");
        if (classData == null) {
            System.out.println("Reloader - Can't load class: "
                    + className);
            throw new ClassNotFoundException();
        }

        System.out.println("defining class..." + className);
        try {
            result = defineClass(null, classData, 0,
                    classData.length);
        } catch (ClassFormatError classFormatError) {
            classFormatError.printStackTrace();
            System.out.println("class format error!!");
            System.exit(0);
        }
        System.out.println("It worked!!! newly defined class:" + result);
        if (result == null) {
            System.out.println("Reloader - Class format error: "
                    + className);
            throw new ClassFormatError();
        }

        if (resolveIt) {
            resolveClass(result);
        }

        // Return class from classPath directory
        return result;
    }

    private Class loadWithSystemClassLoader(String className)
            throws ClassNotFoundException {
        return super.findSystemClass(className);
    }

    public byte[] getByteCodes(String typeName) {

        FileInputStream fis;
        String fileName = classPath + File.separatorChar
                + typeName.replace('.', File.separatorChar)
                + ".class";

        try {
            fis = new FileInputStream(fileName);
        } catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }

        BufferedInputStream bis = new BufferedInputStream(fis);

        ByteArrayOutputStream baos = new ByteArrayOutputStream();

        try {
            int c = bis.read();
            while (c != -1) {
                baos.write(c);
                c = bis.read();
            }
        } catch (IOException e) {
            e.printStackTrace();
            return null;
        }

        return baos.toByteArray();
    }

    public static void testLoadOneClass() {

        String classPath = "C:\\lyon\\tomcat\\common\\classes";
        String className1 = "net.compute.ComputeThis";

        try {

            Reloader rl =
                    new Reloader(classPath);
            System.out.println("loading class...");
            Class c = rl.loadClass(className1);
            byte b[] = rl.getByteCodes(className1);
            print(b);
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }


    }

    public static void print(byte b[]) {
        for (int i = 0; i < b.length; i++) {
            System.out.print((char) (0xff & b[i]));
            if ((i % 10) == 0) System.out.println();
        }
    }

    private static void reloadClasses(String classPath, String className)
            throws ClassNotFoundException {
        System.out.println("loading classpath:" + classPath
                + "loading class name:" + className + "------");
        Reloader rl =
                new Reloader(classPath);
        System.out.println("loading class...");
        Class c = rl.loadClass(className);
        System.out.println("class returned:" + c);
        //((Runnable) c.newInstance()).run();
    }

    public static File[] getClassFiles() {
        DirList dl = new DirList(".class");
        return dl.getFiles();
    }
}

