package classUtils.loaders;

//package net.compute;

import net.compute.DelegatingLoader;

import java.io.*;

/**
 Send the ByteCodeContainer to a remote
 JVM. It uses the RCL to define a new class and
 compute an answer. Computation servers need these
 things to be sent by the computation clients.
 */

public class ByteCodeContainer
        extends ClassLoader
        implements Serializable {
    String className;
    byte byteCodes[];

    public static ByteCodeContainer getLoader(ComputableObject o) {
        return new ByteCodeContainer(o.getClass());
    }

    public ByteCodeContainer(Class c) {
        className = c.getName();
        Reloader rl = new Reloader("C:\\lyon\\j4p\\classes");
        byteCodes = rl.getByteCodes(className);
    }

    public ByteCodeContainer(String cn, byte b[]) {
        byteCodes = b;
        className = cn;
    }

    public ByteCodeContainer(byte b[]) {
        byteCodes = b;
        className = null;
    }

    public void loadIt() {
        loadClass(className, true);
    }

    public Serializable compute()
            throws InstantiationException, IllegalAccessException {
        Class c = defineClass(
                className, byteCodes, 0, byteCodes.length);
        Object o = c.newInstance();
        if (!(o instanceof ComputableObject)) {
            System.out.println("this is computable in remoteclass loader");
            return null;
        }
        return ((ComputableObject) o).compute();
    }

    public void reload() {
        // force the class to be reloaded,
        // in case it has changed.
        try {
            Class c = defineClass(
                    className, byteCodes, 0, byteCodes.length);
            System.out.println("resolving:" + className);
            resolveClass(c);
        } catch (Exception e) {

        }
    }

    Class cl = null;

    public Class getLoadedClass() {
        loadIt();
        return cl;
    }

    protected synchronized Class loadClass(String s, boolean b) {
        cl = findLoadedClass(s);
        try {
            if (cl == null)  // not in cache!
                return findSystemClass(s);
        } catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("defining:" + s);
        Class c = defineClass(
                className, byteCodes, 0, byteCodes.length);
        System.out.println("resolving:" + className);
        if (c != null && b) resolveClass(c);
        return c;
    }

    public static void main(String args[]) {
        File f = futils.Futil.getReadFile("select a class file");
        System.out.println("you selected:" + f);
        String className = f.getName();
        byte[] byteCodes = futils.Futil.readBytes(f);
        ByteCodeContainer bcc = new ByteCodeContainer("", byteCodes);

        Class c = DelegatingLoader.getClassFromFile(f);
        System.out.println("you load a class:" + c);
        Class interfaceClasses[] = c.getInterfaces();
        print(interfaceClasses);
    }

    public static void print(Object o[]) {
        for (int i = 0; i < o.length; i++)
            System.out.println(o.toString());
    }
}