package classUtils.delegate;

import net.rmi.armi.HelloWorld;

import java.util.Date;
import java.util.Vector;

/**
 Main.class
 1. interactively resolve ambiguous invokes using GUI
 2. make topologic sorting an option for resolution or let
 user select a method to resolve ambiguity
 3. add exception handling to the sythesized wrappers
 4. output to a file
 5. compile the file
 */

public class Main {
    public Main() {
        try {
            DelegateGui dg = new DelegateGui();
            // the following code sets the frame's initial state
            dg.init();
            Vector v = new Vector();
            v.addElement(new HelloWorld());
            v.addElement(new Date());
            dg.setInstanceList(v);
            dg.setVisible(true);
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    // Main entry point
    static public void main(String[] args) {
        new Main();
    }

}
