package classUtils.delegate;

import javax.swing.JOptionPane;
import java.awt.FileDialog;
import java.awt.Frame;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.OutputStreamWriter;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Date;
import java.util.Vector;

/**
 * DelegateSynthesizer class
 * These classes are use reflectutil to automatically
 * generate a new class file
 */
public class DelegateSynthesizer {
    private String className = "";
    private String methodList = "";
    private Vector instanceVector = new Vector();
    private Vector uniqueMethodVector = new Vector();
    private Vector duplicateMethodVector = new Vector();
    private Vector compositeMethodVector = new Vector();
    private boolean isTopologicallySorted = false;
    private boolean isDebugging = false;

    public void printUniqueMethodList() {
        for (int i = 0; i < uniqueMethodVector.size(); i++) {
            System.out.println(uniqueMethodVector.elementAt(i));
        }
    }

    public void setToplogicalSorting(boolean b) {
        isTopologicallySorted = b;
    }

    // compare method with all methods in uniqueMethodList, if equal,
    // then add it to dupmethodlist, or else append at the end.
    public void addMethod(String cn, Method m) {
        int i, j;
        boolean pos_found = false;
        Method other;
        i = 0;
        println("uniqueMethodList size=" + uniqueMethodVector.size());
        j = uniqueMethodVector.size();
        getException(m);
        try {
            while (i <= j && !pos_found) {
                if (i == j) {
//					uniqueClassnameList.addElement(cn);
                    uniqueMethodVector.addElement(m);
                    pos_found = true;
                } else {
                    other = (Method) uniqueMethodVector.elementAt(i);
                    if (equals(other, m)) {
                        // if it's toplogic, do nothing
                        addNonTopologic(other);

                        // add current to dup vectors
                        getDuplicateMethodVector().addElement(m);
                        pos_found = true;
                    }
                    i++;
                }
            }
        } catch (Exception e) {
        }
    }

    private void println(String s) {
        if (isDebugging)
            System.out.println(s);
    }

    private void addNonTopologic(Method other) {
        if (!isTopologicallySorted) {
            // duplicate record, copy from unique to dup vector
            // but if the same one has been copied alread, do not copy again
            if (getDuplicateMethodVector().indexOf(other) == -1)
                getDuplicateMethodVector().addElement(other);
        }
    }

    public void addDupMethod(Object o) {
        getDuplicateMethodVector().addElement(o);
    }

    public void removeDupMethod(Object o) {
        getDuplicateMethodVector().removeElement(o);
    }

    public void addDoMethod(Object o) {
        getCompositeMethodVector().addElement(o);
    }

    public void removeDoMethod(Object o) {
        getCompositeMethodVector().removeElement(o);
    }

    // build both unique method list and duplicate method list
    public void buildMethodList(Object o) {
        ReflectUtil ru = new ReflectUtil(o);
        String cn = stripPackageName(ru.getClassName());
        className = className + stripPackageName(cn);
        Method m[] = ru.getAllMethods();
        println("getAllmethods returned:" + m.length);
        println("\nClass: " + cn);
        for (int i = 0; i < m.length; i++)
            addMethod(cn, m[i]);
    }

    public void process() {
        for (int i = 0; i < instanceVector.size(); i++)
            buildMethodList(instanceVector.elementAt(i));
        System.out.println("\ntotal unique method: " + uniqueMethodVector.size() +
                "\nTotal duplicated method: " + getDuplicateMethodVector().size());
    }

    public void add(Object o) {
        instanceVector.addElement(o);
    }

    private String getException(Method m) {
        Class c[];
        String s = new String();
        c = m.getExceptionTypes();
        if (c.length > 0) {
            s = "throws ";
            s = s + c[0].getName();
        }
        // in case have more than one exception, this will work
        for (int i = 1; i < c.length; i++)
            s = s + "," + c[i].getName();
        return s;
    }

    public String getInterface() {
        StringBuffer sb = new StringBuffer("interface ");
        sb.append(getInterfaceName() + "Stub extends \n");
        sb.append("\t" + getImplementsList());
        sb.append(" {\n");
        sb.append("}");
        sb.append(getInterfaces());
        return sb.toString();
    }

    public String getInterfaces() {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < instanceVector.size(); i++)
            sb.append(getInterface(instanceVector.elementAt(i)));
        return sb.toString();
    }

    public String getInterface(Object o) {
        String s = "\n interface "
                + getStubName(o)
                + " {\n"
                + getMethodPrototypes(o)
                + " }";
        return s;
    }

    private String getImplementsList() {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < instanceVector.size() - 1; i++)
            sb.append(getStubName(instanceVector.elementAt(i)) + ", ");
        sb.append(getStubName(instanceVector.elementAt(instanceVector.size() - 1)));
        return sb.toString();
    }

    private String getStrippedClassName(Object o) {
        ReflectUtil ru = new ReflectUtil(o);
        return stripPackageName(ru.getClassName());
    }

    private String getStubName(Object o) {
        ReflectUtil ru = new ReflectUtil(o);
        return stripPackageName(ru.getClassName() + "Stub");
    }

    private String getInterfaceName() {
        StringBuffer sb = new StringBuffer("");
        for (int i = 0; i < instanceVector.size(); i++)
            sb.append(getStrippedClassName(instanceVector.elementAt(i)));
        return sb.toString();
    }

    public String getConstructorParameters() {
        StringBuffer sb = new StringBuffer("\n\t");
        for (int i = 0; i < instanceVector.size(); i++)
            buildConstructorParameter(i, sb);
        return sb.toString();
    }

    private void buildConstructorParameter(int i, StringBuffer sb) {
        ReflectUtil ru = new ReflectUtil(instanceVector.elementAt(i));
        String instanceName =
                stripPackageName(ru.getClassName()).toLowerCase();
        sb.append(ru.getClassName()
                + " _"
                + instanceName);
        if (i < instanceVector.size() - 1)
            sb.append(",\n\t");
    }

    private String getConstructorBody() {
        StringBuffer sb = new StringBuffer("\n\t");
        for (int i = 0; i < instanceVector.size(); i++)
            buildConstructor(i, sb);
        return sb.toString();
    }

    private void buildConstructor(int i, StringBuffer sb) {
        ReflectUtil ru = new ReflectUtil(instanceVector.elementAt(i));
        String instanceName =
                stripPackageName(ru.getClassName()).toLowerCase();
        sb.append(instanceName
                + " = _"
                + instanceName
                + ";");
        if (i < instanceVector.size() - 1)
            sb.append("\n\t");
    }

    private String getMethodPrototypes(Object o) {
        ReflectUtil ru = new ReflectUtil(o);
        String cn = stripPackageName(ru.getClassName());
        String instanceName = cn.toLowerCase();
        Method m[] = ru.getAllMethods();
        return getMethodPrototypes(m, instanceName);
    }

    private void processInstance(Object o) {
        ReflectUtil ru = new ReflectUtil(o);
        String cn = stripPackageName(ru.getClassName());
        String instanceName = cn.toLowerCase();
        className = className +
                stripPackageName(cn);
        Method m[] = ru.getAllMethods();
        methodList = methodList
                + " " + ru.getClassName() + " " + instanceName + ";\n"
                + getMethodList(m, instanceName);
    }

    public String getMethodList(Method m[], String instanceName) {
        String s = "";
        for (int i = 0; i < m.length; i++)
            if (getDuplicateMethodVector().indexOf(m[i]) == -1)
                s = s + getMethodDeclaration(m[i], instanceName) + "\n";
        return s;
    }

    public String getMethodPrototypes(Method m[], String instanceName) {
        String s = "";
        for (int i = 0; i < m.length; i++)
            s = s + getMethodPrototype(m[i], instanceName) + "\n";
        return s;
    }

    public String getMethodDeclaration(Method m, String instanceName) {
        if (isPublic(m))
            return "\t"
                    + "public" // strip out other modifiers.
                    + " "
                    + getReturnType(m)
                    + " "
                    + m.getName()
                    + "("
                    + getParameters(m)
                    + ") "
                    + getException(m)
                    + " {\n\t"
                    + getInvocation(m, instanceName)
                    + "\t}";
        return "";
    }

    public String getMethodPrototype(Method m, String instanceName) {
        if (isPublic(m))
            return "\t"
                    + "public" // strip out other modifiers.
                    + " "
                    + getReturnType(m)
                    + " "
                    + m.getName()
                    + "("
                    + getParameters(m)
                    + ");";
        return "";
    }

    public static String getReturnType(Method m) {
        return getTypeName(m.getReturnType());
    }

    public static boolean isReturningVoid(Method m) {
        return getReturnType(m).startsWith("void");
    }

    public static String getModifiers(Method m) {
        return Modifier.toString(m.getModifiers());
    }

    private String getOptionalReturn(Method m) {
        if (isReturningVoid(m)) return "";
        return "return ";
    }

    private String getInvocation(Method m, String instanceName) {
        StringBuffer sb = new StringBuffer("\t"
                + getOptionalReturn(m)
                + instanceName
                + "."
                + m.getName()
                + "(");
        Class[] params = m.getParameterTypes();
        for (int j = 0; j < params.length; j++) {
            sb.append("v" + j);
            if (j < (params.length - 1))
                sb.append(",");
        }
        sb.append(");\n");
        return sb.toString();
    }

    public String getParameters(Method m) {
        StringBuffer sb = new StringBuffer("");
        Class[] params = m.getParameterTypes(); // avoid clone
        for (int j = 0; j < params.length; j++) {
            sb.append(getTypeName(params[j]) + " v" + j);
            if (j < (params.length - 1))
                sb.append(",");
        }
        return sb.toString();
    }

    public static String getTypeName(Class type) {
        if (!type.isArray())
            return type.getName();
        Class cl = type;
        int dimensions = 0;
        while (cl.isArray()) {
            dimensions++;
            cl = cl.getComponentType();
        }
        StringBuffer sb = new StringBuffer();
        sb.append(cl.getName());
        for (int i = 0; i < dimensions; i++)
            sb.append("[]");
        return sb.toString();
    }

    public static boolean isPublic(Method m) {
        return
                Modifier.toString(m.getModifiers()).startsWith("public");
    }

    public static String stripPackageName(String s) {
        int index = s.lastIndexOf('.');
        if (index == -1) return s;
        index++;
        return s.substring(index);
    }

    private String getConstructor() {
        // public className(class1 _class1Instance, class2 _class2Instance...) {
        //	class1Instance = _class1Instance;
        //  class2Instance = _class2Instance;
        //}
        return "\n// constructor: \npublic "
                + className
                + "("
                + getConstructorParameters()
                + "){"
                + getConstructorBody()
                + "\n}\n\n";
    }

    public String getClassString() {
        return
                "// automatically generated by the DelegateSynthesizer"
                + "\npublic class "
                + className
                + " {\n"
                + getConstructor()
                + methodList
                + "}\n";
    }

    public void print() {
        print(getClassString());
    }

    private void print(Object o) {
        System.out.println(o);
    }

    /**
     * Compares this <code>Method</code> against the specified object.  Returns
     * true if the objects are the same.  Two <code>Methods</code> are the same if
     * they were declared by the same class and have the same name
     * and formal parameter types.
     */
    public boolean equals(Method obj1, Method obj2) {
        if (obj1 != null && obj2 != null) {
            if ((obj1.getName().equals(obj2.getName()))) {
                /* Avoid unnecessary cloning */
                Class[] params1 = obj1.getParameterTypes();
                Class[] params2 = obj2.getParameterTypes();
                if (params1.length == params2.length) {
                    for (int i = 0; i < params1.length; i++) {
                        if (params1[i] != params2[i])
                            return false;
                    }
                    return true;
                }
            }
        }
        return false;
    }

    public String getSaveFileName(String prompt) {
        FileDialog fd = new FileDialog(new Frame(),
                prompt,
                FileDialog.SAVE);
        fd.setFile(className + ".java");
        fd.setVisible(true);
        fd.setVisible(false);
        String fn = fd.getDirectory() + fd.getFile();
        if (fd.getFile() == null) return null;
        return fn;
    }

    public void createFile() {
        String fn = getSaveFileName("save file as");
        if (fn == null) {
            JOptionPane.showMessageDialog(null,
                    "No filename is specified! " +
                    "operation aborted.",
                    "Wait a second",
                    JOptionPane.INFORMATION_MESSAGE);
            return;
        }
        File f = new File(fn);
        createFile(f);
    }

    private void createFile(File f) {
        BufferedWriter bw = null;
        // open file
        try {
            bw = new BufferedWriter(new FileWriter(f));
        } catch (Exception e) {
        }
        createFile(bw);
    }

    /**
     * Use the ds to generate output into
     * a string.
     *
     * @return a list of classes with interfaces for proxy delegation
     */
    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedWriter bw = new BufferedWriter(new OutputStreamWriter(baos));
        createFile(bw);
        return baos.toString();
    }

    public void createFile(BufferedWriter bw) {
        Object[] savedDupMethodList = new Object[getDuplicateMethodVector().size()];
        Object[] savedDoMethodList = new Object[getCompositeMethodVector().size()];

        // default is user chosen solving ambg, now we need to rebuild
        // the dupMethodList according to toplogic rule
        if (isTopologicallySorted == true)
            topoSave(savedDupMethodList, savedDoMethodList);
        className = "";
        methodList = "";
        for (int i = 0; i < instanceVector.size(); i++)
            processInstance(instanceVector.elementAt(i));
        try {
            bw.write("package finalexam;\n" + getClassString() + getInterface());
        } catch (Exception e) {
        }
        try {
            bw.close();
        } catch (Exception e) {
        }
        if (isTopologicallySorted == true)
            sortTopologic(savedDupMethodList, savedDoMethodList);
    }

    private void sortTopologic(Object[] savedDupMethodList, Object[] savedDoMethodList) {
        //put data back to dup list
        getDuplicateMethodVector().removeAllElements();
        getCompositeMethodVector().removeAllElements();
        for (int i = 0; i < savedDupMethodList.length; i++)
            getDuplicateMethodVector().addElement(savedDupMethodList[i]);
        for (int i = 0; i < savedDoMethodList.length; i++)
            getCompositeMethodVector().addElement(savedDoMethodList[i]);
    }

    private void topoSave(Object[] savedDupMethodList, Object[] savedDoMethodList) {
        // reset the dup method list and unique method list
        getDuplicateMethodVector().copyInto(savedDupMethodList);
        getCompositeMethodVector().copyInto(savedDoMethodList);
        getDuplicateMethodVector().removeAllElements();
        getCompositeMethodVector().removeAllElements();
        uniqueMethodVector.removeAllElements();
        for (int i = 0; i < instanceVector.size(); i++)
            buildMethodList(instanceVector.elementAt(i));
    }

    // write the specified string to file
    public void writeSaveFile(BufferedWriter bw, String s) {
        try {
            bw.write(s);
        } catch (Exception e) {
        }
    }

    public static void main(String args[]) {
        DelegateSynthesizer ds = new DelegateSynthesizer();
//		ds.add(new ChineseExample());
//		ds.add(new AmericanExample());
        ds.add(new Date());
        ds.add(new String());
        ds.process();
        System.out.println(ds.getClassString() +
                ds.getInterface());
    }

    public Vector getCompositeMethodVector() {
        return compositeMethodVector;
    }

    public void setCompositeMethodVector(Vector compositeMethodVector) {
        this.compositeMethodVector = compositeMethodVector;
    }

    public Vector getDuplicateMethodVector() {
        return duplicateMethodVector;
    }

    public void setDuplicateMethodVector(Vector duplicateMethodVector) {
        this.duplicateMethodVector = duplicateMethodVector;
    }
}

