package bookExamples.ch26Graphics.draw2d;

class Vec2d {
    public double v[] = new double[2];

    public Vec2d(double x, double y) {
        v[0] = x;
        v[1] = y;
    }

    public Vec2d(Vec2d u) {
        v[0] = u.v[0];
        v[1] = u.v[1];
    }

    // methods
    public final double dot(Vec2d B) {
        return (v[0] * B.v[0] + v[1] * B.v[1]);
    }

    public final double dot(double Bx, double By) {
        return (v[0] * Bx + v[1] * By);
    }

    public static final double dot(Vec2d A, Vec2d B) {
        return (A.v[0] * B.v[0] + A.v[1] * B.v[1]);
    }

    // forms c = a*this+B
    public Vec2d linearComb(double a, Vec2d B) {
        return
                new Vec2d(
                        a * v[0] + B.v[0],
                        a * v[1] + B.v[1]);
    }


    public final double length() {
        return (double) Math.sqrt(v[0] * v[0] + v[1] * v[1]);
    }


    public final void normalize() {
        double t = v[0] * v[0] + v[1] * v[1];
        if (t != 0 && t != 1) t = (double) (1 / Math.sqrt(t));
        v[0] *= t;
        v[1] *= t;
    }

    public String toString() {
        return new String("[" + v[0] + ", " + v[1] + "]");
    }

    // A = a*A;
    public void mult(double factor) {
        v[0] = v[0] * factor;
        v[1] = v[1] * factor;
    }

    // A = A + B
    public void add(Vec2d B) {
        v[0] = v[0] + B.v[0];
        v[1] = v[1] + B.v[1];
    }

    // A = A - B
    public void sub(Vec2d B) {
        //if (B == null) System.out.println("B=null in sub/vec2d");
        v[0] = v[0] - B.v[0];
        v[1] = v[1] - B.v[1];
    }

}
