package bookExamples.ch26Graphics.draw2d;

import java.awt.*;

public class Rect2d extends Shape {
    int x1 = 0;
    int y1 = 0;
    int h = 1;
    int w = 1;
    int xc = 0;
    int yc = 0;

    public int getX() {
        return x1;
    }

    public int getY() {
        return y1;
    }

    public int getW() {
        return w;
    }

    public int getH() {
        return h;
    }


    public Rect2d(int _x1, int _y1, int _x2, int _y2) {
        x1 = _x1;
        y1 = _y1;
        w = Math.abs(_x2 - x1);
        h = Math.abs(_y2 - y1);
        if (_x1 > _x2) x1 = _x2;
        if (_y1 > _y2) y1 = _y2;
        xc = x1 + w / 2;
        yc = y1 + h / 2;

    }

    public void paint(Graphics g) {
        g.drawRect(x1, y1, w, h);
        g.fillOval(xc, yc, 2, 2);
        g.drawString("(" + xc + "," + yc + ")", xc + 3, yc + 3);
    }
}
