package bookExamples.ch26Graphics.draw2d;

import ip.gui.frames.JShortCutFrame;
import j2d.ImageUtils;

import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class JDrawTest extends JShortCutFrame
        implements MouseListener, MouseMotionListener {
    Font font
            = new Font("Times", Font.PLAIN, 12);
    private JMenuBar mb = new JMenuBar();
    private JMenu fileMenu = new JMenu("File");
    private JMenuItem saveAsPict_mi =
            addMenuItem(fileMenu, "[E-s]ave as pict");
    private JMenuItem line_mi =
            addMenuItem(fileMenu, "[l]ine");
    private JMenuItem circle_mi =
            addMenuItem(fileMenu, "[c]ircle");
    private JMenuItem oval_mi =
            addMenuItem(fileMenu, "[o]val");
    private JMenuItem rect_mi =
            addMenuItem(fileMenu, "[r]ect");
    private JMenuItem string_mi =
            addMenuItem(fileMenu, "[s]tring");
    private JMenuItem lens_mi =
            addMenuItem(fileMenu, "[L]ens");
    private JMenuItem ray_mi =
            addMenuItem(fileMenu, "[R]ay shoot");
    private JMenuItem erase_mi =
            addMenuItem(fileMenu, "[e]rase");
    private JMenuItem lastSelected = line_mi;
    private Shapes shapeList = new Shapes();
    private int x1, y1;
    private int x2, y2;
    private int xl, yl;

    public JMenuItem addMenuItem(JMenu aMenu, String itemName) {
        JMenuItem mi = new JMenuItem(itemName);
        aMenu.add(mi);
        mi.addActionListener(this);
        return (mi);
    }

    JDrawTest(String title) {
        super(title);
        mb.add(fileMenu);
        setJMenuBar(mb);
        setBackground(Color.white);
        addMouseMotionListener(this);
        addMouseListener(this);
    }

    private void save() {
        ImageUtils.print(this);
    }

    public void actionPerformed(ActionEvent e) {
        if (match(e, erase_mi)) {
            shapeList = new Shapes();
            repaint();
            return;
        }
        if (match(e, ray_mi)) {
            shapeList.addLineToLastCircle();
            repaint();
            return;
        }
        if (match(e, lens_mi)) {
            lastSelected = lens_mi;
            return;
        }
        if (match(e, string_mi)) {
            lastSelected = string_mi;
            return;
        }
        if (match(e, rect_mi)) {
            lastSelected = rect_mi;
            return;
        }
        if (match(e, saveAsPict_mi)) {
            save();
            return;
        }
        if (match(e, line_mi)) {
            lastSelected = line_mi;
            return;
        }
        if (match(e, circle_mi)) {
            lastSelected = circle_mi;
            return;
        }
        if (match(e, oval_mi)) {
            lastSelected = oval_mi;
            return;
        }
    }

    public static void main(String args[]) {
        JDrawTest drawTest = new JDrawTest("DrawTest");
        drawTest.setSize(300, 300);
        drawTest.show();
    }

    public void mouseDragged(MouseEvent e) {
        e.consume();
        setXl(getX2());
        setYl(getY2());
        setX2(e.getX());
        setY2(e.getY());
        repaint();
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        e.consume();
        setX1(e.getX());
        setY1(e.getY());
        setX2(-1);
    }

    public void mouseReleased(MouseEvent e) {
        e.consume();
        if (lastSelected == lens_mi)
            shapeList.add(new Arc2d(getX1(), getY1(), e.getX(), e.getY()));
        if (lastSelected == string_mi)
            shapeList.add(new String2d(e.getX(), e.getY(), "String me!"));
        if (lastSelected == line_mi)
            shapeList.add(new Line2d(getX1(), getY1(), e.getX(), e.getY()));
        if (lastSelected == rect_mi)
            shapeList.add(new Rect2d(getX1(), getY1(), e.getX(), e.getY()));
        if (lastSelected == circle_mi)
            shapeList.add(new Circle2d(getX1(), getY1(), e.getX(), e.getY()));
        if (lastSelected == oval_mi)
            shapeList.add(new Oval2d(getX1(), getY1(), e.getX(), e.getY()));
        setXl(-1);
        setX2(-1);
        repaint();
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mouseClicked(MouseEvent e) {
    }

    public void drawRubberBand(Graphics g) {
        if (getX2() == -1) return;
        g.setXORMode(getBackground());
        if (lastSelected == lens_mi) {
            Arc2d a =
                    new Arc2d(getX1(), getY1(), getX2(), getY2());
            a.paint(g);
            return;
        }
        if (lastSelected == string_mi) {
            String2d s =
                    new String2d(getX2(), getY2(), "String me!");
            s.paint(g);
            return;
        }
        if (lastSelected == line_mi) {
            g.drawLine(getX1(), getY1(), getX2(), getY2());
            return;
        }
        if (lastSelected == circle_mi) {
            Circle2d c = new Circle2d(getX1(), getY1(), getX2(), getY2());
            c.paint(g);
            return;
        }
        if (lastSelected == oval_mi) {
            Oval2d o = new Oval2d(getX1(), getY1(), getX2(), getY2());
            o.paint(g);
            return;
        }
        if (lastSelected == rect_mi) {
            Rect2d r = new Rect2d(getX1(), getY1(), getX2(), getY2());
            r.paint(g);
            return;
        }
    }

    public void paint(Graphics g) {
        g.setFont(font);
        shapeList.paint(g);
        drawRubberBand(g);
    }

    public int getX1() {
        return x1;
    }

    public void setX1(int x1) {
        this.x1 = x1;
    }

    public int getY1() {
        return y1;
    }

    public void setY1(int y1) {
        this.y1 = y1;
    }

    public int getX2() {
        return x2;
    }

    public void setX2(int x2) {
        this.x2 = x2;
    }

    public int getY2() {
        return y2;
    }

    public void setY2(int y2) {
        this.y2 = y2;
    }

    public int getXl() {
        return xl;
    }

    public void setXl(int xl) {
        this.xl = xl;
    }

    public int getYl() {
        return yl;
    }

    public void setYl(int yl) {
        this.yl = yl;
    }
}













