package bookExamples.ch26Graphics.draw2d;


import java.awt.*;

public class Arc2d extends Shape {
    private int x1 = 0;
    private int y1 = 0;
    private int w = 1;
    private int h = 1;
    private int xc = 0;
    private int yc = 0;
    private int startAngle = 90;
    private int arcAngle = 180;
    private Line2d plane = null;

    public Arc2d(int _x1, int _y1, int _x2, int _y2) {
        x1 = _x1;
        y1 = _y1;
        w = Math.abs(_x2 - x1);
        h = Math.abs(_y2 - y1);
        int _x1PluswOn2 = _x1 + w / 2;
        plane = new Line2d(_x1PluswOn2, _y1, _x1PluswOn2, _y1 + h);
        xc = x1 + w / 2;
        yc = y1 + h / 2;
    }

    public void paint(Graphics g) {
        g.drawArc(x1, y1, w, h, startAngle, arcAngle);
        plane.paint(g);
        g.fillOval(xc, yc, 2, 2);
        g.drawString("(" + xc + "," + yc + ")", xc + 3, yc + 3);
    }
}
