package bookExamples.ch26Graphics.carl.phasor;

import javax.swing.*;
import java.awt.*;

/**
 * Created by IntelliJ IDEA.
 */
public class PlotGraph extends JFrame {
    JPanel plotPanel;
    JPanel controlPanel;
    JButton controlButton;
    Container c;
    double yArray[];
    double xArray[];

    int iyArray[];
    int ixArray[];

    public PlotGraph(String str) {
        super(str);
        Container cc = getContentPane();
        setBackground(Color.red);
        setSize(100, 500);
        setVisible(true);
    }

    /**
     * @param title
     * @param yArr
     * @param xStart
     * @param xStop
     * @param scale
     */


    public PlotGraph(String title, double yArr[], double xStart, double xStop, double scale) {
        super(title);
        c = getContentPane();
        setBackground(Color.yellow);

        convertInputs(yArr, xStart, xStop, scale);

        setSize(300, 300);
        setBackground(Color.MAGENTA);
        setVisible(true);
    }

    private void convertInputs(double y[], double xStar, double xStop, double sca) {
        int n = y.length;
        int nSegs = y.length - 1;
        double fSegs = (float) nSegs;
        xArray = new double[n];
        yArray = new double[n];
        ixArray = new int[n];
        iyArray = new int[n];

        xArray[0] = xStar;
        yArray[0] = y[0];
        double increment = (xStop - xStar) / fSegs;
        for (int i = 1; i < n; i++) {
            xArray[i] = xArray[i - 1] + increment;
            yArray[i] = y[i];
        }

        for (int i = 0; i < n; i++) {
            ixArray[i] = (int) (xArray[i] * sca);
            iyArray[i] = (int) (yArray[i] * sca);
            System.out.println("ixArray = " + ixArray[i]);
            System.out.println("iyArray = " + iyArray[i]);
        }
    }


    public void paint(Graphics g) {
        g.setColor(Color.BLACK);
        g.drawPolyline(ixArray, iyArray, ixArray.length);
    }

    public static void main(String[] args) {
        double sine[] = new double[50];
        for (int i = 0; i < sine.length; i++) {
            sine[i] = 2. + Math.sin(i * 2 * Math.PI / 50);
            System.out.println("sine[i] = " + sine[i]);
        }

        PlotGraph pg = new PlotGraph("This is PlotGraph", sine, 0, 2 * Math.PI, 50);
    }

}
