package bookExamples.ch26Graphics.carl.phasor;

/*  Illustrates the sum of two phasors in real-time.

   omega1 and amp1 are associated with the green vector and
   omega2 and amp2 with the red vector.
 The tips of the vectors are black dots for omega1 and bluish for omega2.
 Interpret in terms of the text in pages 15 and 16 of Steiglitz.

 If you un-comment one of the other two lines in the "paint" method, you will see 1)
 the individual steps of the vector addition or 2)the sine-wave
 beat, making sure that only one line is uncommented and the other
 two are commented out.

*/

import javax.swing.*;
import java.awt.*;
import java.awt.event.*;
class PhasorJFrame2 extends JFrame{

// Geometry of starting points of vectors
	int x1 = 150;
	int y1 = 150;
	int x2 = 150;
	int y2 = 150;

	int xcen = 250;
	int ycen = 250;
	int xOffset = 0;


// Initial parameters of 2 phasors
	static double omega1 = 1;
	static double omega2 = 1.1;
	double amp1 = 60;
	double amp2 = 80;
	double phi1 = 0;	// phase lag
	double phi2 = 0;	// phase lag


	double theta = 0;

	static Timer ticker;
	static TickListener tocker;
	double t = 0;
	static double delt = .05;  // time increment per display sample

	static int milliseconds = 100; //Display timer

	boolean firstStep;

	PhasorJFrame2(double om1, double om2, double am1, double am2, double ph1, double ph2){
		super(" This is phasor demo" );
		// set up phasor parameters
		omega1 = om1;
		omega2 = om2;
		amp1 = am1;
		amp2 = am2;
		phi1 = ph1;
		phi2 = ph2;

		firstStep = true;

		Container c = getContentPane();
		tocker = new TickListener();

		setLocation(400,300);
		setSize(500,500);
		show();
	}


	private class TickListener implements ActionListener {
		public void actionPerformed(ActionEvent e){
			System.out.print (" Tick ");
			upDateGeometry();
			repaint();
		}
	}
	public void paint(Graphics g){
		//super.paint(g);
		drawPhasor(g);
		drawSine(g);
	}

	public void drawPhasor(Graphics g1){
		if ( firstStep ) {
			firstStep = false;
			return;
		}
		g1.setColor(Color.green);
		int xtip = xcen + x1;
		int ytip = ycen + y1;
		g1.drawLine(xcen, ycen, xtip, ytip );
		g1.setColor(Color.red);
		g1.drawLine( xtip, ytip, xtip + x2, ytip + y2);
		g1.setColor(Color.cyan);
		g1.fillOval(xtip, ytip, 4, 4);
		g1.setColor(Color.black);
		g1.fillOval(xtip + x2, ytip + y2, 4, 4);
	}

	public void drawSine(Graphics g2){

		if ( firstStep ) return;
		g2.setColor(Color.black);
		xOffset += 2;
		g2.drawOval( xOffset, ycen +( y1 + y2), 4, 4);

		if ( xOffset > 400) {
			super.paint(g2);
//		g2.clearRect(0,0,500,500);
			xOffset = 0;
		}
	}

	public void upDateGeometry(){

		t += delt;

		double theta1 = t*omega1;
		double theta2 = t*omega2;

		x1 = (int)(amp1*Math.cos(-theta1-phi1));
		y1 = (int)(amp1*Math.sin(-theta1-phi1));

		x2 = (int)(amp2*Math.cos(-theta2-phi2));
		y2 = (int)(amp2*Math.sin(-theta2-phi2));

	}

	static void setSampleTime( double st ){
		// sample time expressed as number of samples per omega wave
		delt = 2*Math.PI/(st*omega1);
	}

	static void setDisplayTick( int tick ){
		milliseconds = tick;
		ticker =  new Timer(milliseconds, tocker);
	}


	public static void main (String args[]){
		// omega1, omega2, amp1, amp2, phi1, phi2
		PhasorJFrame2 pjf = new PhasorJFrame2( -1., -1.1, 60., 60.,0.,0  );

		pjf.setSampleTime(77.77);

		// slow down for closer look (argument is in milliseconds)
		pjf.setDisplayTick( 50 );
		ticker.start();


		// Orderly window closing:
		pjf.addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
      });
	}

}