package bookExamples.ch26Graphics.carl.logPolar;

public class ShuffleTest {
    public int myArray[];
    int rayCount;

    public ShuffleTest() {
        rayCount = 10;
        System.out.println(" Constructor");
        myArray = new int[rayCount];
        for (int i = 0; i < myArray.length; i++) {
            myArray[i] = i;
        }
    }

    public String toString() {
        String str = "";
        for (int i = 0; i < myArray.length; i++)
            str += "   " + myArray[i];
        return str;

    }

    public void shuffleRays(int m) {
        int k;
        int sum = 0;
        int holdColor, holdColor2;
        int counter = 0;
        for (int i = 0; i < rayCount; i += m) {
            counter++;
            holdColor = myArray[i];
            k = m * (((int) (Math.random() * (float) rayCount)) / m);
            sum += k;
            holdColor2 = myArray[k];
            for (int j = 0; j < m; j++) {
                if ((i + j) < rayCount) myArray[i + j] = holdColor2;
                if ((k + j) < rayCount) myArray[k + j] = holdColor;
            }
            System.out.println(m + "  i= " + i + ";  k= " + k + "; " + toString());
        }

        System.out.println(" avg k:" + (float) sum / (float) counter);
    }

    public static void main(String args[]) {
        System.out.println("main");
        ShuffleTest shuf = new ShuffleTest();
        System.out.println(shuf.rayCount);
        System.out.println(shuf.toString());
        shuf.shuffleRays(7);
        System.out.println(shuf.toString());

    }

}