package bookExamples.ch24Reflection;

import classUtils.dumper.ClassFile;
import classUtils.reflection.MethodList;
import futils.DirList;
import futils.Customer;
import gui.In;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;

import xml.adbk.Address;
import addBk.address.AddressRecord;

/**
 * DocJava, Inc.
 * http://www.docjava.com
 * Programmer: dlyon
 * Date: Sep 29, 2004
 * Time: 9:05:56 PM
 */
public class MainUtils {
    public static void main(String[] args) {
        AddressRecord o = new AddressRecord();
        System.out.println(o);
        printProps(o);
    }

    private static void printProps(AddressRecord o) {
        MethodList ml = new MethodList(o.getClass());
        Method ma [] = MethodList.getMethodsWithNArgs(ml.getPublicReadMethods(), 0);
        try {
            for (int i = 0; i < ma.length; i++) {
                System.out.println(ma[i] + ":" +
                        ma[i].invoke(o, null).toString());
            }
        } catch (IllegalAccessException e) {
            e.printStackTrace();
        } catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private static void bigMainTest() {
        try {
            testPrintMainClasses();
        } catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        In.message("done");
    }

    private static void testPrintMainClasses()
            throws ClassNotFoundException {
        DirList dl = new DirList(".class");
        File fa[] = dl.getFilesNotDirectories();
        for (int i = 0; i < fa.length; i++)
            printMainClasses(fa[i]);

        // 1a.  Convert a class file into a Class.
        // 1b. convert the list of files into a list of classes.
        // 2. print out only those classes that contain a
        //    public static void main(String args[]) method.
    }

    private static void printMainClasses(File f) throws ClassNotFoundException {
        ClassFile cf = ClassFile.getClassFile(f);
        String cn = cf.getClassName();
        Class c = Class.forName(cn);
        if (!cf.hasMainMethod()) return;
        System.out.println(c.getName() + " has a main");
        Method m[] = c.getMethods();
        for (int i = 0; i < m.length; i++)
            System.out.println(m[i]);
    }
}
