package addBk.address;

import futils.CsvParser;
import futils.Futil;
import futils.ReaderUtil;

import java.io.BufferedReader;
import java.io.IOException;
import java.util.Vector;

/**
 * CSVReaders are bad way to read in data.
 * A better way is to input a sample instance
 * of a class that is serializable (like an Address),
 * then use the fields of the address to formulate a
 * means of parsing the input data.
 * Such information like, record delimiter, field delimiter
 * and line delimiter should be include during the parsing.
 * But how is this done?
 * Given an instance of the Address class, we can automatically
 * convert the Address into xml using an XmlEncoder, see the
 * toXml method in xml.adbk.Address.
 * So, we need to know the XML schema BEFORE we read in
 * the delimited data. Then, based on the XML schema, and
 * delimiter information, we should be able to read in the
 * data and produce correct AML (Address Markup Language).
 * Thus we need:
 * 1. Record delimiter
 * 2. Field delimiter
 * 3. Line delimiter
 * 4. tag list, in the correct order.
 */

public class CsvReader {
    private BufferedReader br;
    private Vector v = new Vector();

    public CsvReader(BufferedReader _br) {
        br = _br;
        getLines();
        System.out.println("read " + v.size() + " lines");
        System.out.println("number of bad records=" + numberOfBadRecords);
    }

    public CsvReader(BufferedReader _br, char delimiter) {
        br = _br;
        getLines(delimiter);
        System.out.println("read " + v.size() + " lines");
        System.out.println("number of bad records=" + numberOfBadRecords);
    }

    private int numberOfBadRecords = 0;

    class Address {
        String lastName = "";
        String firstName = "";
        String address1 = "";
        String address2 = "";
        String address3 = "";
        String address4 = "";
        String address5 = "";
        String homePhone = "";
        String businessPhone = "";
        String faxPhone = "";

        Address(String s[]) {
            try {
                lastName = s[0];
                firstName = s[1];
                address1 = s[2];
                address2 = s[3];
                address3 = s[4];
                address4 = s[5];
                address5 = s[6];
                homePhone = s[7];
                businessPhone = s[8];
                faxPhone = s[9];
            } catch (ArrayIndexOutOfBoundsException e) {
                numberOfBadRecords++;
            }
        }

        private String outLine(String s) {
            if (s.equals("")) return s;
            return "\n" + s;
        }

        public String toString() {
            return outLine("---")
                    +
                    outLine(firstName + " " + lastName)
                    +
                    outLine(address1)
                    +
                    outLine(address2)
                    +
                    outLine(address3)
                    +
                    outLine(address4)
                    +
                    outLine(address5)
                    +
                    outLine(homePhone)
                    +
                    outLine(businessPhone)
                    + outLine(faxPhone);
        }

    }

    /**
     * Return the address element converted into a string
     *
     * @param i
     * @return
     */
    public String getRecord(int i) {
        return v.elementAt(i).toString();
    }

    private void processLine(String l) {
        v.addElement(new Address(new CsvParser(l).getTokens()));
    }

    private void processLine(String l, char delimiter) {
        v.addElement(new Address(new CsvParser(l, delimiter).getTokens()));
    }

    private void getLines() {
        try {
            for (String l = br.readLine();
                 l != null; l = br.readLine())
                processLine(l);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void getLines(char delimiter) {
        try {
            for (String l = br.readLine();
                 l != null; l = br.readLine())
                processLine(l, delimiter);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String args[]) {
        final char delimiter = ';';
        CsvReader cr = new CsvReader(
                ReaderUtil.getBufferedReader(
                        Futil.getReadFile("Select a CSV file")),delimiter);
        for (int i = 0; i < 10; i++)
            System.out.println(cr.getRecord(i));
    }
}