package addBk.address;

import java.io.Serializable;

public class AddressRecord
        implements Serializable,
        Comparator {
    private String firstName;
    private String lastName;
    private String address1;
    private String address2;
    private String phone1;
    private String phone2;
    private String phone3;

    public String[] getRecordAsArray() {
        String defaultRecord[] =
                {firstName,
                 lastName,
                 address1,
                 address2,
                 phone1,
                 phone2,
                 phone3};
        return defaultRecord;
    }

    public String getPhone1() {
        return phone1;
    }

    public String getPhone2() {
        return phone2;
    }

    public String getPhone3() {
        return phone3;
    }

    public String getLastName() {
        return lastName;
    }

    public int compare(Object o1, Object o2) {
        AddressRecord a1 = (AddressRecord) o1;
        AddressRecord a2 = (AddressRecord) o2;
        String n1 = a1.getLastName();
        String n2 = a2.getLastName();
        return n1.compareTo(n2);
    }

    public boolean equals(Object obj) {
        AddressRecord a =
                (AddressRecord) obj;
        return lastName.equals(a.getLastName());
    }

    public String getAddress1() {
        return address1;
    }

    public String getAddress2() {
        return address2;
    }

    public String getName() {
        return
                firstName +
                " " + lastName;
    }

    public void print() {
        println("Name:" + getLastName());
//println("Address1:"+getAddress1());
//println("Address2:"+getAddress2());
//println("Phone1:"+getPhone1());
//println("Phone2:"+getPhone2());
    }

    public void println(Object o) {
        System.out.println(o);
    }

    public AddressRecord(String s[]) {

        for (int i = 0; i < s.length; i++) {
            switch (i) {
                case 1:
                    firstName = s[1];
                    break;
                case 2:
                    lastName = s[2];
                    break;
                case 3:
                    lastName = s[3];
                    break;
                case 7:
                    address1 = s[3] +
                            "\n" + s[4] + " "
                            + s[5] + " "
                            + s[6] + " "
                            + s[7];
                    break;
                case 8:
                    address2 = s[8];
                    break;
                case 9:
                    phone1 = s[9];
                    break;
                case 10:
                    phone2 = s[10];
                    break;
                case 11:
                    phone3 = s[11];
                    break;
            }
        }
    }

    public AddressRecord() {
        String firstName = "doug";
        String lastName = " lyon";
        String address1 = "300 North Benson Rd.";
        String address2 = "Fairfield CT 06460";
        String phone1 = "203-641-6293";
        String phone2 = "203-254-4000x3155";
        String phone3 = "203-877-4187 fax";
    }


}
