/**
 * XslDomWriter.java
 * @author Thomas Rowland
 * @version 02-08-03
 */

package xml.classInfo;

import futils.Futil;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import java.io.File;
import java.io.IOException;

/*
 * This program demonstrates how to parse an XML file and
 * use XSLT to write it back out to a new XML file.
 * Uses the DOM Level 2 api and JAXP 1.2.
 */

public class XsltDomWriter {

    public static void main(String argv [])
            throws IOException {

        File inFile = Futil.getReadFile("select an XML file");
        File outFile = new File(inFile.getParent() + "\\NewClassInfo.xml");
        Document document = parse("file:" + inFile.getAbsolutePath());
        transform(document, outFile);
    }


    /*
     * Parses an XML file, represented by a URI, and returns the DOM Document
     */
    private static Document parse(String uri)
            throws IOException {

        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        try {
            //dbf.setValidating(true);
            //dbf.setNamespaceAware(true);

            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(uri);
            Element root = doc.getDocumentElement();
            return doc;
        } catch (ParserConfigurationException e) {
            // Factory unable to create parser.
            System.out.println(
                    "DocumentBuilderFactory cannot be instantiated.\n"
                    + e.getMessage());
        } catch (SAXException e) {
            // Parsing error.
            System.out.println(
                    "** SAXException\n"
                    + e.getMessage());
            //get the wrapped exception
            Exception ex = e.getException();
            if (ex != null)
                ex.printStackTrace();
        } catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }


    /*
     * Uses XSLT to write a DOM Document,
     * which may have been modified, back out to an XML file.
     */
    private static void transform(Node node, File outFile) {
        try {
            // Obtain a Transformer
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer t = tf.newTransformer();

            // Create a source object
            DOMSource source = new DOMSource(node);

            // Create a result object and perform the transform
            StreamResult result = new StreamResult(outFile);
            t.transform(source, result);

            result = new StreamResult(System.out);
            t.transform(source, result);
        } catch (TransformerConfigurationException e) {
            // Exception generated by the TransformerFactory
            System.out.println(
                    "Error creating the Transformer"
                    + "\n" + e.getMessage());
            Throwable x = e;
            if (e.getException() != null)
                x = e.getException();
            x.printStackTrace();
        } catch (TransformerException e) {
            // Exception generated by the transformer
            System.out.println(
                    "Error during transformation"
                    + "\n" + e.getMessage());
            Throwable x = e;
            if (e.getException() != null)
                x = e.getException();
            x.printStackTrace();
        }
    }

}//