package xml.adbk;

import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import java.io.IOException;

/**
 * xml.Xml2Address reads AML and makes address books.
 */

public class Xml2Address {
    public static AddressBook read(String uri)
            throws
            SAXParseException,
            SAXException,
            ParserConfigurationException,
            IOException {

        SAXParserFactory spf
                = SAXParserFactory.newInstance();
        spf.setValidating(true);

        SAXParser sp = spf.newSAXParser();

        ParseAml dh = new ParseAml();
        sp.parse(uri, dh);
        return dh.getAddressBook();
    }

}


