package xml.adbk;

import futils.Futil;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

import javax.xml.parsers.ParserConfigurationException;
import java.io.File;
import java.io.IOException;

/**
 * Created by
 * User: lyon
 * Date: Jan 3, 2004
 * Time: 10:58:16 AM
 *
 */
public class Main {
    public static void main(String argv [])
            throws IOException {
        try {

            AddressBook ab = Xml2Address.read("file:" +
                    Futil.getReadFile(
                            "select an XML file").getAbsolutePath());
            System.out.println("AB (csv)=" + ab.toCsv());
            //System.out.println("AB (xml)=" + ab.toXml());
            AddressBook ab2 = ab.search("yan");
            ab.merge(ab2);

            System.out.println("html=" + ab.toHtmlCsv());
            gui.html.HtmlViewer hv =
                    new gui.html.HtmlViewer();
            hv.setHtml(ab.toHtmlCsv());
            ab.saveAsXml(new File("c:\\lyon\\doug.xml"));

        } catch (SAXParseException e) {
            System.out.println(
                    "** Parsing error"
                    + ", line " + e.getLineNumber()
                    + ", uri " + e.getSystemId()
                    + "   " + e.getMessage()
            );

        } catch (SAXException e) {
            e.printStackTrace();
        } catch (ParserConfigurationException e) {
            e.printStackTrace();
        }
    }
}
