/*
 * @author Douglas A. Lyon
 * @version  Nov 6, 2002.8:03:04 AM
 */
package xml;


import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;


public class XmlUtil {
    /**
     *  getParser returns a SAXParser
     * This was changed to reflect
     * the latest jaxp distro.
     * Since it was subject to
     * deprecation before
     * it is wise to isolate
     * the feature here.
     * This is an example of
     * defensive programming.
     */
    public static SAXParser getParser()
            throws
            org.xml.sax.SAXException,
            ParserConfigurationException {
        // The SAXParserFactory is a a
        // factory class that enables productions
        // of XML parsers:
        SAXParserFactory spf
                = SAXParserFactory.newInstance();

        // setValidating (true) specifies that
        // the parser will validate documents
        // during parsing:

        spf.setValidating(true);
        return spf.newSAXParser();
    }
}
