package utils;

import java.util.StringTokenizer;


public class ReplaceString {

    public static String sub(String line,
                             String stringToEliminate,
                             String replacementString) {
        int lineSize = line.length();
        int ssSize = stringToEliminate.length();
        int i = line.indexOf(stringToEliminate);
        if (i < 0) return line;
        return line.substring(0, i) + replacementString
                + line.substring(i + ssSize);
    }

    public static String replaceFirstInstance(
            String inputString, String searchString, String replacementString) {
        int i = inputString.indexOf(searchString);
        if (i == -1) return inputString;
        int ssSize = searchString.length();
        String part1 = inputString.substring(0, i);
        String part2 = inputString.substring(i + ssSize);
        return part1 + replacementString + part2;
    }
    /**
     * replaceAll
     * @param s  input String
     * @param searchString  The string to searchFor
     * @param replaceString  The string to replace it with
     * @return new string
     */
    public static String replaceAll(
            String s,
            String searchString,
            String replaceString) {
        int i = s.indexOf(searchString);
        if (i == -1) return s;
        int ssSize = searchString.length();
        while (i != -1) {
            String part1 = s.substring(0, i);
            String part2 = s.substring(i + ssSize);
            s = part1 + replaceString + part2;
            i = s.indexOf(searchString,
                    i + replaceString.length());
        }
        return s;
    }


    public static void main(String args[]) {
        testBug(args);

    }


    public static String replaceAll(String s, String ss[], String rs) {
        for (int i = 0; i < ss.length; i++)
            s = replaceAll(s, ss[i], rs);
        return s;
    }

    public static void testBug(String args[]) {
        String s = "c:\\test";
        s = replaceAll(s, "\\", "/");
        System.out.println(s);
    }

    public static void testReplace(String args[]) {
        String ss[] = {"if", "then", "static"};
        String s = "public static public static if if then static";
        s = replaceAll(s, ss, "");
        System.out.println(s);
    }

    /** Determine how many tokens are in a string
     *
     * @param l The string to be processed
     * @return the number of tokens
     */
    public static int addTokens(String l) {
        System.out.println(l);
        int sum = 0;
        StringTokenizer st
                = new StringTokenizer(
                        l, ", \t\r\f\n\"\\;");
        int tc = st.countTokens();
        System.out.println("tc=" + tc);
        for (int i = 0; i < tc; i++) {
            String s = st.nextToken();
            int j = 0;
            try {
                j = Integer.parseInt(s);
            } catch (NumberFormatException e) {

            }
            System.out.println(j);
            sum = sum + j;
        }
        return sum;
    }
}
