package sound;

import gui.ClosableJFrame;
import gui.run.RunButton;
import gui.run.RunSlider;
import math.transforms.FFT1d;

import javax.swing.*;
import java.awt.*;

// For the final which is due next week...
// Use the 4 voice synthesizer to generated a wave form.
// Play the waveform through the speakers.
// Plot the waveform using the oscopePanel.
// Show a panel with the Power Spectrial Density of the waveform.
// Come to class.
// Set up your final.
// Demo to the class.
// Hand in the printout, with floppy.
// Go home!
// Just like what I did just now, but use 4 voices. Each
// is controlled with 7 sliders. You add the output of the 4
// voices togther.
/**
 * Created by
 * User: lyon
 * Date: Nov 23, 2003
 * Time: 1:35:35 PM
 *
 */

/**
 * Created by IntelliJ IDEA.
 * User: dlyon
 * Date: Nov 17, 2003
 * Time: 7:44:50 PM
 * To change this template use Options | File Templates.
 */

//Sliders on the left--Oscope on the right
//Play button in the south
//single voice to play


public class VoicePanel extends JPanel {
    private int frequency = 440;
    private double harmonics[] = {
        1, 0, 0, 0, 0, 0, 0
    };
    OscopePanel op = new OscopePanel();
    FFT1d fft = new FFT1d();
    private Voice v = new Voice(frequency);
    Oscillator o = new Oscillator(440, 80);
    Audio a = new Audio(o.getSineWave());
    OscopePanel spectrumAnalyzer =
            FFT1d.getSpectrumPanel(o.getSineWave(), "PSD");

    ClosableJFrame cf = new ClosableJFrame("OscilatorFrame");
    JLabel frequencyLabel = new JLabel("400 Hz");

    public Voice getVoice() {
        return v;
    }

    public int getFrequency() {
        return frequency;
    }

    public static void main(String args[]) {
        //VoicePanel vp = new VoicePanel();
        //vp.initTestFrame();
        testGetVoicePanels();
    }

    private RunSlider getHarmonicSlider(final int i) {
        RunSlider rs = new RunSlider(RunSlider.HORIZONTAL) {
            public void run() {
                harmonics[i] = getValue() / 100.0;
            }
        };
        rs.setValue(0);
        return rs;
    }


    private RunSlider getFrequencySlider() {
        return new RunSlider(RunSlider.HORIZONTAL) {
            public void run() {
                setFrequency(10 * getValue());
            }
        };
    }

    public RunButton getPlayButton() {
        return new RunButton("play") {
            public void run() {
                play();
            }
        };
    }

    public VoicePanel() {
        addComponents();
    }


    private void addComponents() {
        setLayout(new GridLayout(0, 1));
        add(getLabeledFrequencySlider());
        for (int i = 0; i < 7; i++)
            add(getLabeledSlider(i));
        add(getPlayButton());
    }

    private JPanel getLabeledFrequencySlider() {
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        jp.add(frequencyLabel, BorderLayout.WEST);
        jp.add(getFrequencySlider(), BorderLayout.CENTER);
        return jp;
    }

    private JPanel getLabeledSlider(int i) {
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        jp.add(new JLabel("s" + i), BorderLayout.WEST);
        jp.add(getHarmonicSlider(i), BorderLayout.CENTER);
        return jp;
    }

    public static void log(double a[]) {
        for (int i = 0; i < a.length; i++)
            a[i] = Math.log(a[i]);
    }

    public void play() {
        v.setFrequency(frequency);
        v.setHarmonic(harmonics);
        v.play();
        op.setDoubleData(v.getVoicedWave());
        double[] psd = FFT1d.getPsd(v.getVoicedWave());
        spectrumAnalyzer.setDoubleData(
                psd);
        op.repaint();
        spectrumAnalyzer.repaint();
    }

    public void setFrequency(int f) {
        frequency = f;
        frequencyLabel.setText(f + " Hz");
    }

    public static void testGetVoicePanel() {
        ClosableJFrame cf = new ClosableJFrame();
        Voices voices = new Voices();
        Container c = cf.getContentPane();
        c.setLayout(new BorderLayout());
        c.add(getVoicePanel(voices), BorderLayout.CENTER);
        c.setSize(400, 400);
        cf.show();
    }

    public static void testGetVoicePanels() {
        ClosableJFrame cf = new ClosableJFrame();
        Container c = cf.getContentPane();
        c.setLayout(new BorderLayout());
        c.add(getVoicePanels(), BorderLayout.CENTER);
        c.setSize(400, 400);
        cf.show();
    }
      public static JPanel getVoicePanel(Voices voices) {
        JPanel c = new JPanel();
        c.setLayout(new GridLayout(1, 0));
        VoicePanel vp = new VoicePanel();
        Voice v = vp.getVoice();
        voices.add(v);
        OscopePanel op = vp.op;
        Oscillator o = vp.o;
        OscopePanel spectrumAnalyzer =
                vp.spectrumAnalyzer;
        c.add(vp);
        c.add(op);
        c.add(spectrumAnalyzer);
        return c;
    }
    public static JPanel getCompositeVoicePanel(
            final Voices voices) {
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(1, 0));
        OscopePanel op = new OscopePanel(
                voices.getVoicedWaveForm(),
                "composite");
        OscopePanel spectrumAnalyzer =
                new OscopePanel(voices.getVoicedWaveForm(),"PSD");
        jp.add(op);
        jp.add(spectrumAnalyzer);
        jp.add(new VoicesRunButton(voices,op,spectrumAnalyzer));
        return jp;
    }

    public static JPanel getVoicePanels() {
        Voices voices = new Voices();
        JTabbedPane jtp = new JTabbedPane();
        JPanel v1 = getVoicePanel(voices);
        jtp.add("voice1", v1);
        JPanel v2 = getVoicePanel(voices);
        jtp.add("voice2", v2);
        JPanel v3 = getVoicePanel(voices);
        jtp.add("voice3", v3);
        JPanel v4 = getVoicePanel(voices);
        jtp.add("voice4", v4);
        jtp.add("composite voice",
                getCompositeVoicePanel(voices));
        JPanel jp = new JPanel();
        jp.setLayout(new BorderLayout());
        jp.add(jtp, BorderLayout.CENTER);
        return jp;
    }

    public class VoicePlusPanel {
        private JPanel jpanel;
        private Voice voice;

        VoicePlusPanel(JPanel _jp, Voice _v) {
            jpanel = _jp;
            voice = _v;
        }

        public JPanel getJpanel() {
            return jpanel;
        }

        public Voice getVoice() {
            return voice;
        }
    }



    private void initTestFrame() {
        Container c = cf.getContentPane();
        c.setLayout(new GridLayout(1, 0));
        c.add(this);
        c.add(op);
        c.add(spectrumAnalyzer);
        cf.setSize(600, 400);
        cf.setVisible(true);
    }

    private static class VoicesRunButton extends RunButton {
        private final Voices voices;
        private final OscopePanel op;
        private final OscopePanel psd;

        public VoicesRunButton(Voices voices, OscopePanel op,
                               OscopePanel psd) {
            super("Play");
            this.voices = voices;
            this.op = op;
            this.psd = psd;
        }

        public void run(){
            voices.play();
            op.setDoubleData(voices.getVoicedWaveForm());
            double psdVals[] =
                    FFT1d.getPsd(voices.getVoicedWaveForm());
            psd.setDoubleData(psdVals);
            psd.repaint();
            op.repaint();
        }
    }
}


