package sound;

import gui.run.RunSlider;
import gui.run.RunRadio;
import gui.run.RunButton;

import javax.swing.*;
import java.awt.*;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class SynthesizerController extends JFrame {
    OscillatorModel om = new OscillatorModel();
    public SynthesizerController() {
        Container synthesizerFrame = initPanels();
        handleCloseEvent();
        setSize(700, 400);
        show();
    }

    private void handleCloseEvent() {
        addWindowListener(
                new WindowAdapter() {
                    public void windowClosing(WindowEvent e) {
                        System.exit(0);
                    }
                }
        );
    }

    private int runRadioState = 1;

    private JPanel getRadioButtonPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(1, 0));
        ButtonGroup bg = new ButtonGroup();
        addRadioButton(bg, jp, "a", 1);
        addRadioButton(bg, jp, "b", 2);
        addRadioButton(bg, jp, "c", 3);
        addRadioButton(bg, jp, "d", 4);
        return jp;
    }

    private void addRadioButton(ButtonGroup bg,
                                JPanel jp,
                                String label,
                                final int state) {
        RunRadio rr2 = new RunRadio(label) {
            public void run() {
                runRadioState = state;
            }
        };
        bg.add(rr2);
        jp.add(rr2);
    }

    private Container initPanels() {
        Container c = getContentPane();
        c.setLayout(new FlowLayout());
        c.add(getHarmonicSliderPanel(harmonicAmplitudes));
        c.add(getFrequencySliderPanel());
        c.add(getVolumeSliderPanel());
        c.add(getRadioButtonPanel());
        c.add(getButtonControllerPanel());
        c.add(getWaveformPanel());
        return c;
    }
    private JPanel getWaveformPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new GridLayout(1,0));
        Voice v[] = om.getVoices();
        for (int i=0; i < v.length; i++) {
            OscopePanel op = new OscopePanel(

                                        v[i].getVoicedWave(),"v"+i);
            op.setLabelsVisible(false);
            jp.add(op);
        }
        OscopePanel op = new OscopePanel(om.getVoicedWave(),"composite");
        op.setLabelsVisible(false);
        jp.add(op);
        return jp;
    }
    private void play() {
        om.play();
    }
    private void graph() {
        // do the view;
    }
    private JPanel getButtonControllerPanel() {
        JPanel jp = new JPanel();
        jp.setLayout(new FlowLayout());
        jp.add(new RunButton("play"){
            public void run() {
              play();
            }
        });
        jp.add(new RunButton("graph"){
            public void run() {
              graph();
            }
        });
        return jp;
    }

    private double frequencies[] = new double[4];

    private JPanel getFrequencySliderPanel() {
        JPanel controlPanel = new JPanel(new GridLayout(0, 1));
        JLabel label = new JLabel("Frequency", JLabel.CENTER);
        controlPanel.add(label);
        for (int i = 0; i < 4; i++) {
            setUpFrequencySlider(i, controlPanel);
        }
        return controlPanel;
    }

    private void setUpFrequencySlider(final int frequencyNumber,
                                      JPanel controlPanel) {
        RunSlider rs = new RunSlider(SwingConstants.HORIZONTAL) {
            public void run() {
                System.out.println("Frequency Slider #" +
                        frequencyNumber + " = " + getValue());
                frequencies[frequencyNumber] = getValue();
            }
        };
        String label1 = "#" + frequencyNumber;
        rs.setName("A");
        rs.setToolTipText(label1);
        rs.setToolTipText(label1);
        controlPanel.add(rs);
    }

    private JPanel getVolumeSliderPanel() {
        JPanel controlPanel = new JPanel(new GridLayout(0, 1));
        JLabel label = new JLabel("Volume", JLabel.CENTER);
        controlPanel.add(label);
        RunSlider rs = new RunSlider(SwingConstants.HORIZONTAL) {
            public void run() {
                System.out.println("Volume = " + getValue());
            }
        };
        controlPanel.add(rs);

        return controlPanel;
    }

    private static JPanel getHarmonicSliderPanel(double[] harmonicAmplitudes1) {
        JPanel labeledPanel = new JPanel(new BorderLayout());
        JPanel controlPanel = new JPanel(new GridLayout(1, 0));
        JLabel label = new JLabel("Harmonics", JLabel.CENTER);
        label.setAlignmentY(JLabel.CENTER_ALIGNMENT);
        labeledPanel.add(label, BorderLayout.NORTH);
        labeledPanel.add(controlPanel, BorderLayout.CENTER);
        for (int i = 0; i < 7; i++)
            addSlider(harmonicAmplitudes1, controlPanel, SwingConstants.VERTICAL, i);
        return labeledPanel;
    }

    private double harmonicAmplitudes[] = new double[7];

    public static void addSlider(final double[] harmonicAmplitudes1,
                                 Container c,
                                 int orientation,
                                 final int harmonicNumber) {
        RunSlider rs = new RunSlider(orientation) {
            public void run() {
                System.out.println(
                        "Harmonic Slider #" +
                        harmonicNumber + " = " + getValue());
                harmonicAmplitudes1[harmonicNumber] = getValue();
            }
        };
        String label = "harmonic:" + harmonicNumber;
        rs.setToolTipText(label);
        rs.setToolTipText(label);
        c.add(rs);
    }


    public static void main(String args[]) {
        SynthesizerController app = new SynthesizerController();


    }
}

