package sound;

/**
 * Created by
 * User: lyon
 * Date: Nov 29, 2003
 * Time: 11:11:38 AM
 *
 */

import gui.run.RunScroll;

import javax.swing.*;
import java.awt.*;


public class OscopePanel
        extends JPanel {

    private double[] doubleData;


    private int dx = 0;
    private int oldDx = 0;

    private int dy = 0;
    private int oldDy = 0;

    private final double
            xScaleFactors[] = {50000, 25000, 10000, 5000, 2500, 1000,
                               500, 250, 100, 50, 25, 10,
                               5, 2.5, 1, .5, .25, .1,
                               .05, .025, .01, .005, .0025, .001,
                               .0005};

    private final String xSFLabels[] = {"0.05 u", "0.1 u", "0.25 u",
                                        "0.5 u", "1 u", "2.5 u",
                                        "5 u", "10 u", "25 u",
                                        "50 u", "100 u", "250 u",
                                        "500 u", "1 m", "2.5 m",
                                        "5 m", "10 m", "25 m",
                                        "50 m", "100 m", "250 m",
                                        "500 m", "1 ", "2.5 ",
                                        "5 "};

    private final int xsfStartIndex = 14;
    private double xScaleFactor = xScaleFactors[xsfStartIndex];
    private double oldXScaleFactor = xScaleFactors[xsfStartIndex];
    private String xSFLabel = new String(xSFLabels[xsfStartIndex]);
    private boolean labelsVisible = true;

    public void setLabelsVisible(boolean b) {
        labelsVisible = b;
    }

    public static final double
            yScaleFactors[] = {
                50000,
                25000,
                10000,
                5000,
                2000,
                1000,
                500,
                200,
                100,
                50,
                20,
                10,
                5, 2, 1, .5, .2, .1};

    public static final String
            ySFLabels[] = {
                "1 m", "2.5 m",
                "5 m", "10 m",
                "25 m", "50 m",
                "100 m", "250 m",
                "500 m",
                "1 ", "2.5 ",
                "5 ", "10 ",
                "20 ", "50 ",
                "100 ","250 ","500 "};


    private final int yScaleFactorStartIndex = 8;
    private double yScaleFactor = 1;
    private double oldYScaleFactor = 1;
    private String ySFLabel = new String(ySFLabels[yScaleFactorStartIndex]);
    private TracePanel tracePanel = new TracePanel();

    public OscopePanel() {
        this(new Oscillator(440, 1000).getSineWave(),
                "Scope");
    }
    public Dimension getPreferredSize() {
        return new Dimension(400,200);
    }

    public OscopePanel(double _doubleData[], String title) {

        doubleData = _doubleData;
        setLayout(new BorderLayout());

        RunScroll sbHorzTop =
                new RunScroll(Scrollbar.HORIZONTAL) {
                    public void run() {

                        int i = getValue();
                        xScaleFactor = xScaleFactors[i];

                        if (xScaleFactor != oldXScaleFactor) {
                            xSFLabel = xSFLabels[i];
                            tracePanel.repaint(500);
                            oldXScaleFactor = xScaleFactor;
                        }
                    }
                };
        // Set top scrollbar characteristics
        sbHorzTop.setValues(xsfStartIndex, 0, 0, 24);

        RunScroll sbHorzBottom =
                new RunScroll(Scrollbar.HORIZONTAL) {
                    public void run() {
                        dx = getValue();

                        if (dx != oldDx) {
                            tracePanel.repaint(500);
                            oldDx = dx;
                        }
                    }
                };

        RunScroll sbVertLeft =
                new RunScroll(Scrollbar.VERTICAL) {
                    public void run() {
                        dy = getValue();

                        if (dy != oldDy) {
                            tracePanel.repaint(500);
                            oldDy = dy;
                        }
                    }
                };
        RunScroll sbVertRight =
                new RunScroll(Scrollbar.VERTICAL) {
                    public void run() {
                        int i = getValue();
                        yScaleFactor = yScaleFactors[i];

                        if (yScaleFactor != oldYScaleFactor) {
                            ySFLabel = ySFLabels[i];
                            tracePanel.repaint(500);
                            oldYScaleFactor = yScaleFactor;
                        }

                    }
                };
        // Set right scrollbar characteristics
        sbVertRight.setValues(yScaleFactorStartIndex, 0, 0,
                yScaleFactors.length-1);


        // Set left scrollbar characteristics
        sbVertLeft.setValues(0, 0, -300, 300);

        add(sbHorzTop, BorderLayout.NORTH);
        add(sbHorzBottom, BorderLayout.SOUTH);
        add(sbVertLeft, BorderLayout.WEST);
        add(sbVertRight, BorderLayout.EAST);
        add(tracePanel, BorderLayout.CENTER);

        setBackground(Color.white);
        // Set bottom scrollbar characteristics based on sample length
        sbHorzBottom.setValues(0, 0, 0, doubleData.length);
    }


    public void setDoubleData(double d[]) {
        doubleData = d;
    }


    class TracePanel extends JPanel {

        private boolean drawGrid = true;
        private Color gridColor = new Color(0, 255, 0);
        private Dimension dim;
        private int height,width;

        public void setGridColor(Color c) {
            gridColor = c;
        }

        public void grid(int grid_spacing, Graphics g, Color c) {
            Rectangle r = g.getClipBounds();

            int w = r.width;
            int h = r.height;

            Color oldColor = g.getColor();
            g.setColor(c);

            for (int x = 0; x < w; x = x + grid_spacing) {
                g.drawLine(x, 0, x, h);
            }

            for (int y = 0; y < h; y = y + grid_spacing) {
                g.drawLine(0, y, w, y);
            }

            g.setColor(oldColor);

        }

        public void paint(Graphics g) {
            drawData(g);
            if (!labelsVisible) return;
            drawXScaleLabel(g);
            drawYScaleLabel(g);
        }

        private void drawData(Graphics g) {
            double limit = (doubleData.length * xScaleFactor);

            dim = getSize();
            height = dim.height;
            width = dim.width;
            g.clearRect(0, 0, width, height);

            if (drawGrid)
                grid(20, g, gridColor);


            if (limit > width) limit = (double) width;

            int j = dx;

            done:
            for (double i = 0; i < limit; i += xScaleFactor) {
                if (j >= (doubleData.length - 1))
                    break done;
                g.drawLine(
                        (int) i,
                        (int) (height - (
                        (doubleData[j] * yScaleFactor)
                        * height / 4 + height / 2)) - dy,

                        (int) (i + xScaleFactor),

                        (int) (height - (
                        (doubleData[j + 1] * yScaleFactor)
                        * height / 4 + height / 2)) - dy);

                j++;

            }
        }

        private void drawXScaleLabel(Graphics g) {
            int height = 10;
            int xloc = 20;
            int yloc = 20;

            String xsfLabel = xSFLabel + "sec/div";

            int string_width = getFontMetrics(
                    g.getFont()).stringWidth(xsfLabel);
            int string_height = getFontMetrics(
                    g.getFont()).getHeight();

            g.clearRect(xloc, yloc, string_width, string_height);
            g.drawString(xsfLabel, xloc, height + yloc);
        }


        private void drawYScaleLabel(Graphics g) {
            int height = 10;
            int xloc = 20;
            int yloc = dim.height - 60;

            String ysfLabel = ySFLabel + "v/div";

            int string_width = getFontMetrics(
                    g.getFont()).stringWidth(ysfLabel);
            int string_height = getFontMetrics(
                    g.getFont()).getHeight();

            g.clearRect(xloc, yloc, string_width, string_height);
            g.drawString(ysfLabel, xloc, height + yloc);
        }
    }

    public static void main(String args[]) {
        OscopePanel osp = new OscopePanel();
        gui.ClosableJFrame cf = new gui.ClosableJFrame();
        Container c = cf.getContentPane();
        c.add(osp);
        c.setLayout(new GridLayout(1,0));
        cf.setSize(400,400);
        cf.show();
    }


}

