package sound;

import javax.sound.midi.MidiFileFormat;
import javax.sound.midi.Sequence;
import java.awt.*;

// to get this to import on a mac,
// add to the class path:
// /System/Library/Frameworks/JavaVM.framework/Versions/1.3.1/Classes/ui.jar

public class MidiFileInfo {
    private static final int LOAD_METHOD_STREAM = 1;
    private static final int LOAD_METHOD_FILE = 2;
    private static final int LOAD_METHOD_URL = 3;

    public static String getReadFile() {
        FileDialog fd = new FileDialog(new Frame(), "select a midifile");
        fd.show();
        fd.hide();
        return fd.getDirectory() + fd.getFile();
    }


    public static void main(String[] args) {
        int nLoadMethod = LOAD_METHOD_FILE;
        boolean bCheckSequence = false;
        int nCurrentArg = 0;
        String strSource = getReadFile();
        String strFilename = strSource;
        MidiFileFormat fileFormat = null;
        Sequence sequence = null;

        /*
         *	And now, we output the data.
         */
        if (fileFormat == null) {
            System.out.println("Cannot determine format");
        } else {
            System.out.println("---------------------------------------------------------------------------");
            System.out.println("Source: " + strFilename);
            System.out.println("Midi File Type: " + fileFormat.getType());

            float fDivisionType = fileFormat.getDivisionType();
            String strDivisionType = null;
            if (fDivisionType == Sequence.PPQ) {
                strDivisionType = "PPQ";
            } else if (fDivisionType == Sequence.SMPTE_24) {
                strDivisionType = "SMPTE, 24 frames per second";
            } else if (fDivisionType == Sequence.SMPTE_25) {
                strDivisionType = "SMPTE, 25 frames per second";
            } else if (fDivisionType == Sequence.SMPTE_30DROP) {
                strDivisionType = "SMPTE, 29.97 frames per second";
            } else if (fDivisionType == Sequence.SMPTE_30) {
                strDivisionType = "SMPTE, 30 frames per second";
            }

            System.out.println("DivisionType: " + strDivisionType);

            String strResolutionType = null;
            if (fileFormat.getDivisionType() == Sequence.PPQ) {
                strResolutionType = " ticks per beat";
            } else {
                strResolutionType = " ticks per frame";
            }
            System.out.println("Resolution: " + fileFormat.getResolution() + strResolutionType);

            String strFileLength = null;
            if (fileFormat.getByteLength() != MidiFileFormat.UNKNOWN_LENGTH) {
                strFileLength = "" + fileFormat.getByteLength() + " bytes";
            } else {
                strFileLength = "unknown";
            }
            System.out.println("Length: " + strFileLength);

            String strDuration = null;
            if (fileFormat.getMicrosecondLength() != MidiFileFormat.UNKNOWN_LENGTH) {
                strDuration = "" + fileFormat.getMicrosecondLength() + " microseconds)";
            } else {
                strDuration = "unknown";
            }
            System.out.println("Duration: " + strDuration);

            if (bCheckSequence) {
                System.out.println("[Sequence says:] Length: " + sequence.getTickLength() + " ticks (= " + sequence.getMicrosecondLength() + " us)");
            }
            System.out.println("---------------------------------------------------------------------------");
        }
    }

}


/*** MidiFileInfo.java ***/
