package sound;

import javax.sound.midi.Synthesizer;
import java.awt.*;


public class Main extends KeyProcessor {
    static class MouseFrame extends Frame {
        MouseFrame() {
            setSize(200, 200);
            setVisible(true);
            MusicMouseListener mp
                    = new MusicMouseListener();
            KeyProcessor kp
                    = new KeyProcessor();
            addMouseMotionListener(mp);
            addMouseListener(mp);
            addKeyListener(kp);
        }
    }

    public static void main(String args[]) {
        new MouseFrame();
        for (int i = 0; i < 127; i++)
            System.out.println(i + "=" + (char) i);
        StochasticControl.randomNotes(Scales.getScale(
                Scales.HARMONIC_MINOR, 32, 74), 10);
    }


    public static void testNote() {
        int nNoteNumber = 64;	// MIDI key number
        int nVelocity = 127;   //0..127
        int nDuration = 500;   // ms
        Synthesizer synth = Utils.getSynthesizer();
        Utils.play(synth, nNoteNumber, nVelocity, nDuration);
    }

}