package sound;

/*
 * Open Source Software by http://www.Docjava.com
 * programmer: D. Lyon
 * e-mail: lyon@docjava.com
 * Date: Apr 30, 2002
 * Time: 3:40:56 PM
 */

import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public class KeyProcessor
        implements KeyListener {
    int scale[] = Scales.getScale(
            Scales.CHROMATIC, 23, 64);

    PetriNodes pn = SongReader.initMarkov(20);
    KeyMap km = new KeyMap();


    public void keyPressed(KeyEvent
            e) {
        int c = e.getKeyChar();

        Utils.noteOn(km.getNoteNumber(c), 127);
    }

    public void keyTyped(KeyEvent
            e) {
        /*
         int c = e.getKeyChar();
         System.out.println("key="+c);
         if (e.isAltDown()) {
             (pn.getNode(c % 9)).play();
             return;
         }

         if (e.isShiftDown())
             Utils.play(SongReader.getNextNote());
         else
             Utils.play(scale[c % scale.length], -1);
        */
    }

    public void keyReleased(KeyEvent
            e) {
        int c = e.getKeyChar();
        System.out.println("key released:" + c);
        Utils.noteOff(km.getNoteNumber(c));
    }
}
