package sound;

import gui.run.RunButton;

import javax.swing.*;
import java.awt.*;
import java.io.File;

/********************************************************/

/**
 * A sound recorder/player application.
 * <p>
 * <b>
 * Fairfield University<br>
 * CR310/SW511:
 * <i>Digital Audio with Java</i>
 * </b>
 */
public class JCapture extends
        JFrame implements AudioPlayerListener {
    AudioPlayer player = new AudioPlayer();
    JTextField audioFormatField = new JTextField();
    JPanel buttonBar = new JPanel();
    JTextField stateField = new JTextField(10);
    File currentDirectory;

    /********************************************************/
    /**
     * Initialize the application without displaying the GUI.
     */
    public JCapture() {
        super("Audio Capture Tool");

        player.addAudioPlayerListener(this);

        buttonBar.setLayout(new FlowLayout());

        buttonBar.add(new RunButton("Capture") {
            public void run() {
                try {
                    player.captureAudio();
                    updateUIStrings();
                } catch (AudioPlayerException a) {
                    messageBox(a.getMessage());
                }
            }
        });
        buttonBar.add(new RunButton("Stop") {
            public void run() {
                player.stop();
            }
        });
        buttonBar.add(new RunButton("Play") {
            public void run() {
                try {
                    player.playAudio();
                } catch (AudioPlayerException a) {
                    messageBox(a.getMessage());
                }
            }
        });
        buttonBar.add(new RunButton("Save") {
            public void run() {
                try {
                    AudioFileChooser afc = new AudioFileChooser(currentDirectory);
                    afc.setDialogType(AudioFileChooser.SAVE_DIALOG);
                    afc.setSourceFormat(player.getFormat());
                    afc.show();
                    if (afc.getSelectedFile() != null) {
                        player.saveAudioFile(afc.getSelectedFile(),
                                afc.getSelectedEncoding());
                        currentDirectory = afc.getCurrentDirectory();
                        updateUIStrings();
                    }
                } catch (AudioPlayerException a) {
                    messageBox(a.getMessage());
                }
            }
        });
        buttonBar.add(new RunButton("Open") {
            public void run() {
                try {
                    AudioFileChooser afc = new AudioFileChooser(currentDirectory);
                    afc.setDialogType(AudioFileChooser.OPEN_DIALOG);
                    afc.show();
                    if (afc.getSelectedFile() != null) {
                        player.openAudioFile(afc.getSelectedFile());
                        currentDirectory = afc.getCurrentDirectory();
                        updateUIStrings();
                    }
                } catch (AudioPlayerException a) {
                    messageBox(a.getMessage());
                }
            }
        });
        buttonBar.add(stateField);
        stateField.setEditable(false);

        audioFormatField.setEditable(false);

        Container contentPane = getContentPane();

        contentPane.setLayout(new BorderLayout());
        contentPane.add(buttonBar, BorderLayout.NORTH);
        contentPane.add(audioFormatField, BorderLayout.SOUTH);

        setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);

        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    /********************************************************/
    /**
     * Implementation of AudioPlayerListener.
     */
    public void audioStateChanged(AudioPlayer.State s) {
        stateField.setText(s.toString());
    }

    /********************************************************/
    /**
     * Internal shortcut for displaying an error message box.
     */
    private void messageBox(String s) {
        JOptionPane.showMessageDialog(this, s,
                "Audio Capture Tool", JOptionPane.WARNING_MESSAGE);
    }

    /********************************************************/
    /**
     * Internal shortcut for updating GUI strings.
     */
    private void updateUIStrings() {
        setTitle("Audio Capture Tool - " + player.getAudioDescription());
        audioFormatField.setText(player.getFormat() + "");
    }

    /********************************************************/
    /**
     * Create and display and instance of the application.
     */
    public static void main(String args[]) {
        JCapture c = new JCapture();
        c.setSize(500, 200);
        c.show();
    }
}
