package serialPorts;

/**
 * Created by
 * User: lyon
 * Date: Dec 29, 2003
 * Time: 10:06:24 AM
 *
 */

import gnu.io.*;

import java.io.*;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Vector;

public class Utils {

    private static void dial() throws IOException,
            UnsupportedCommOperationException,
            PortInUseException {
        listPorts();
        CommPortIdentifier cpid = Utils.getPortByName("/dev/cu.modem");
        SerialPort sp = (SerialPort) cpid.open("Utils", 200);
        PrintStream ps = new PrintStream(sp.getOutputStream());
        BufferedReader br
                = new BufferedReader(
                        new InputStreamReader(sp.getInputStream()));
        setPort(sp);
        String messageString = "atdt8770890";
        ps.print(messageString + "\r\n");
        checkModemResponse(br, messageString);
        sp.close();
    }


    private static void checkModemResponse(BufferedReader br, String messageString) throws IOException {
        if (!receive(br, messageString))
            System.err.println("WARNING: Modem did not echo command.");


// The modem sends an extra blank line by way of a prompt.
// Here we read and discard it.
        String junk = br.readLine();
        if (junk.length() != 0) {
            System.err.print("Warning unexpected response: ");
            System.err.println(junk);
            System.out.println("port closed");
        }
    }

    private static void setPort(SerialPort sp) throws UnsupportedCommOperationException {
        sp.setSerialPortParams(
                9600,
                SerialPort.DATABITS_8,
                SerialPort.STOPBITS_2,
                SerialPort.PARITY_NONE);
        sp.setDTR(true);
        sp.setRTS(true);
    }

    public static boolean receive(BufferedReader br, String whatToExpect) {
        boolean returnedValue = false;
        String response = "";

        try {
            response = br.readLine();

            returnedValue = response.indexOf(whatToExpect) >= 0;
        } catch (IOException err) {
            System.out.println(
                    "error occurred while trying to "
                    + "receive data from the serial port "
                    + "through the reader object");
        }

        return returnedValue;
    }

    public static void sendString(OutputStream os, String s)
            throws IOException {
        byte b[] = s.getBytes();
        os.write(b);
    }

    public static CommPortIdentifier getPortByName(String name) {
        CommPortIdentifier cpid[] = getComPortIdentifiers();
        for (int i = 0; i < cpid.length; i++) {
            if (cpid[i].getName().equals(name))
                return cpid[i];

        }
        return null;
    }

    public static CommPortIdentifier[] getComPortIdentifiers() {
        Vector v = new Vector();
        Enumeration pi = CommPortIdentifier.getPortIdentifiers();
        while (pi.hasMoreElements())
            v.addElement(pi.nextElement());
        CommPortIdentifier cpid[] = new CommPortIdentifier[v.size()];
        v.copyInto(cpid);
        return cpid;
    }

    /* If you are having trouble under OSX, use
  copy rxtx-2.1-6/MACOSX_IDE/CW/librxtxSerial.jnilib
  to:
  /System/Library/Frameworks/JavaVM.framework/Versions/1.4.1/Libraries

  */
    public static void listPorts() {
        System.out.println("testPortIdentifiers:start");
        CommPortIdentifier cpid[] = getComPortIdentifiers();
        if (cpid.length == 0) {
            System.out.println(
                    "no com ports detected!"
                    + " program terminated.");
            return;
        }
        for (int i = 0; i < cpid.length; i++)
            print(cpid[i]);
        System.out.println("testPortIdentifiers:done");

    }

    public static void print(CommPortIdentifier cpid) {
        System.out.print("port:" + cpid.getName() + "\t"
                + "CurrentOwner:" + cpid.getCurrentOwner() + "\t"
                + "isCurrentlyOwned=" + cpid.isCurrentlyOwned());
        // isCurrentlyOwned
        // indicates if another Java
        // application owns the port.
        if (cpid.getPortType() ==
                CommPortIdentifier.PORT_SERIAL)
            System.out.println(":PORT_SERIAL");
        if (cpid.getPortType() ==
                CommPortIdentifier.PORT_PARALLEL)
            System.out.println(":PORT_PARALLEL");
    }

    private static void openAndClosePort(CommPortIdentifier cpid)
            throws PortInUseException {
        CommPort port = cpid.open("TurnTable", 20);
        System.out.println("  Opened successfully");
        port.close();
    }


    private static void testTurnTable()
            throws
            PortInUseException,
            IOException,
            UnsupportedCommOperationException {
        CommPortIdentifier portId;
        Utils tt = new Utils();
        System.out.println("getPortIdentifiers...");
        Enumeration portList = CommPortIdentifier.getPortIdentifiers();
        System.out.println("getPortIdentifiers... done!");

        while (portList.hasMoreElements()) {
            portId = (CommPortIdentifier) portList.nextElement();
            if
            (portId.getPortType() == CommPortIdentifier.PORT_SERIAL) {
                if (portId.getName().equals("COM3")) {
                    processPort(portId);

                }

            }

        }
    }


    private static void processPort(CommPortIdentifier portId)
            throws PortInUseException,
            IOException,
            gnu.io.UnsupportedCommOperationException {
        System.out.println("portId=" + portId.getName());
        SerialPort sp =
                openSerialPort(portId);

        OutputStream os = sp.getOutputStream();
        setUpSerialPort(sp);
        sendMagicNumber(os);
        sleepSec(10);
        moveStepperMotor(os);
        closeSerialPort(sp);
        System.out.println("port closed");
        System.in.read();
    }

    private static SerialPort openSerialPort(CommPortIdentifier portId)
            throws PortInUseException {
        return (SerialPort)
                portId.open("SimpleWriteApp", 2000);

    }

    private static void setUpSerialPort(SerialPort sp)
            throws UnsupportedCommOperationException {
        sp.setSerialPortParams(9600, SerialPort.DATABITS_8,
                SerialPort.STOPBITS_2, SerialPort.PARITY_NONE);
    }

    private static void sendMagicNumber(OutputStream os)
            throws IOException {
        byte[] mn = {27, 13, 27, 13, 27, 13, 0};
        os.write(mn);
        System.out.println("Send magic number..");
    }

    private static void moveStepperMotor(OutputStream os)
            throws IOException {
        byte[] st = {'M', 0, 0, 0, 0, 0, 0, 7, 0, 0, 13, 10};
        os.write(st);
        System.out.println("Move step.");
    }

    private static void closeSerialPort(SerialPort sp) {
//tt.step(1);
//sleepSec(2);
//tt.step(2);
//sleepSec(2);
//tt.step(3);
//sleepSec(2);

        sp.close();
    }


    public void step(OutputStream os, int n) throws IOException {
        System.out.println("Move " + n + " steps");
        byte[] st = {'M', 0, 0, 0, 0, 0, 0, 7, 0, 0, 13, 10};
        for (int i = 0; i < n; i++)
            os.write(st);
    }


    public static void sleepSec(int sec) {

        try {

            Thread.sleep(sec * 1000);

        } catch (InterruptedException e) {
        }

    }

}
