package print.labels;

import java.awt.*;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.awt.print.PrinterException;

public class PrintableLabel
        implements Printable {
    private Graphics2D g;
    private PageFormat fmt;
    private int xoff, yoff;
    private final int INCH = 72;
    private MailingLabelList labelList;

    public PrintableLabel(MailingLabelList v) {
        labelList = v;

        xoff = 18;
        //note the non-obvious y-offset
        yoff = (int) (-6.5 * INCH);
    }

    //-----------
    //called by printing system
    //note that this simplistic example only prints page 0
    public int print(Graphics gr, PageFormat pageFormat, int page)
            throws PrinterException {
        if (page == 0) {
            this.fmt = pageFormat;
            this.g = (Graphics2D) gr;

            printPage();
            return PAGE_EXISTS;
        } else
            return NO_SUCH_PAGE;
    }

    private void printPage() {
        MailingLabel s[] = labelList.getLabels();
        for (int i = 0; i < s.length; i++)
            printLabel(s[i]);
    }

    private void printLabel(MailingLabel label) {
        //draw borders in light gray
        g.setColor(Color.lightGray);
        Dimension labelSize = label.getPreferredSize();
        g.drawRect(xoff, yoff, labelSize.width, labelSize.height);

        g.setColor(Color.black);

        String s[] = label.getLines();

        Font roman = new Font("Serif", Font.PLAIN, 12);
        g.setFont(roman);
        int fontHeight =  14;

        for (int i = 0; i < s.length; i++) {
            int localX = xoff + INCH / 4;

            int localY = yoff + (i+1)*fontHeight;

            g.drawString(s[i], localX, localY);

        }
        xoff += labelSize.width;
        if (xoff > labelSize.width*3) {
            xoff = 18;
            yoff += labelSize.height;
        }
    }
}
