package net.stocks;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Vector;

public class Quote {
  public static void main(String args[]) {

    Vector s = new Vector();
    s.addElement("aapl");
    s.addElement("open");
    s.addElement("xlnx");
    s.addElement("altr");
    s.addElement("mot");
    s.addElement("cy");
    s.addElement("crus");
    s.addElement("sfa");
    s.addElement("adbe");
    s.addElement("nn");
    s.addElement("msft");
    s.addElement("sunw");
    printVector(
        getUrl(
            makeQuoteURLString(s)));

  }

  public static void printVector(Vector v) {
    for (int i = 0; i < v.size(); i++) {
      System.out.println(v.elementAt(i));
    }
  }

  public static Vector getUrl(String _URLString) {
    Vector contents = new Vector();
    BufferedReader in = null;
    try {
      URL URLString = new URL(_URLString);
      in = new BufferedReader(new
              InputStreamReader(URLString.openStream()));

      String line;
      contents.addElement("Copyright 1999 by Doug Lyon http://www.docjava.com");
      contents.addElement("symbol\tprice\tdate\ttime" +
                          "  (20 min. Delay)\t  change\t  open\t  bid\t  ask\t  volume");

      while (null != (line = in.readLine()))
        contents.addElement(line);

    } catch (Exception e) {
      e.printStackTrace();
    } finally {
      try {
        if (in != null) in.close();
      } catch (IOException e) {
        e.printStackTrace();
      }
    }
    return contents;
  }

  public static String makeQuoteURLString(Vector symbols) {
    String symbolsString = "";
    for (int i = 0; i < symbols.size(); i++) {
      String symbol = (String) symbols.elementAt(i);
      symbolsString += ((i != 0) ? "," : "") + symbol.toUpperCase();
    }
    return
        "http://quote.yahoo.com/download/javasoft.beans?SYMBOLS=" +
        symbolsString +
        "&format=sl";
  }
}
