package net.server.servlets;


/**
 * The SelectSectionPage class is a type of HTML page
 * which is used to prompt a user to select the section id
 * for a previously selected course id.
 *
 * @author Robert Lysik
 * @version 1.00
 */
class SelectSectionPage extends net.server.servlets.HtmlPage {

    /**
     * This is the default constructor for the
     * SelectSectionPage class. The parent constructor
     * is caller with the page title, 'Section Selection Page'.
     * A form is added to the page which is used to prompt
     * the user to select a section id for the course which
     * they had selected during a prvious step.
     */
    SelectSectionPage(String courseId, String[] sectionIds) {
        super("Section Selection Page");

        addText("Select a section ID for course " +
                courseId +
                " from the following list:");
        startForm("get",
                "http://localhost:8080/examples/servlet/FormProcessorServlet");
        addBreak();
        addText(getSelect("section", "1", sectionIds, sectionIds));
        addBreak();
        addSubmit("Enter");
        addHidden("course", courseId);
        addHidden("status", "section_id_selected");
        endForm();
    }
}