package net.server.servlets;

/**
 *  Html Class
 */

public class Html {

    /**
     * Html Constructor
     *
     * Don't let anyone instantiate this class
     */

    private Html() {

    }

    /**
     * getHtml    Method
     *

     * @return    String
     */

    public static String getHtml(String s) {
        return "\n\n" + s + "\n";
    }

    /**
     * getHead     Method
     *

     * @return     String
     */

    public static String getHead(String s) {
        return "<Head>\n" + s + "\n</Head>\n";
    }


    /**
     * getTitle    Method
     *

     * @return     String
     */

    public static String getTitle(String s) {
        return "<title>\n" + s + "\n</title>\n";
    }


    /**
     * getBody     Method
     *

     * @return     String
     */

    public static String getBody(String s) {
        return "<body>\n" + s + "\n</body>";
    }


    /**
     * getH1       Method
     *
     * @return     String
     */

    public static String getH1(String s) {
        return "<h1>\n" + s + "\n</h1>";
    }

    /**
     * getH2       Method
     *
     * @return     String
     */

    public static String getH2(String s) {
        return "<h2>\n" + s + "\n</h2>";
    }


    /**
     * getH3       Method
     *
     * @return     String
     */

    public static String getH3(String s) {
        return "<h3>\n" + s + "\n</h3>";
    }


    /**
     * getH4       Method
     *
     * @return     String
     */

    public static String getH4(String s) {
        return "<h4>\n" + s + "\n</h4>";
    }


    /**
     * getH5       Method
     *
     * @return     String
     */

    public static String getH5(String s) {
        return "<h5>\n" + s + "\n</h5>";
    }


    /**
     * getH6       Method
     *
     * @return     String
     */

    public static String getH6(String s) {
        return "<h6>\n" + s + "\n</h6>";
    }


    /**
     * getForm      Method
     *
     * @return      String
     */

    public static String getForm(String action, String method, String s) {
        return "\n<form action=" + quote(action) +
                "method=" + quote(method) + ">\n" +
                s + ' ' + " </form >\n";
    }


    /**
     * getForm      Method
     *
     * @return      String
     */

    public static String getForm(String name, String action,
                                 String method, String s) {
        return "\n<form name=" + quote(name)
                + " " + "action=" + quote(action)
                + " " + "method=" + quote(method)
                + " " + "target=" + quote("_self")
                + ">\n"
                + s + ' ' + " </form >\n";
    }


    /**
     * getTable     Method
     *
     * @return      String
     */

    public static String getTable(String s, String border,
                                  String width, String noWrap) {

        return "\n<Table Border=" + quote(border) +
                "Width=" + quote(width) + noWrap + ">" +
                s + "</Table>";

    }

    /**
     * getTable     Method
     *

     * @return      String
     */

    public static String getTable(String s, String align, String border,
                                  String width, String noWrap) {

        return "\n<Table Align = " + quote(align)
                + "Border=" + quote(border)
                + "Width=" + quote(width)
                + noWrap + ">"
                + s
                + "</Table>";

    }

    /**
     * getTable     Method
     *
     * @return      String
     */

    public static String getTable(int nr, int nc) {
        String s = "\n<Table Border=1>";

        for (int r = 1; r <= nr; r++) {
            s = s + getTr(getRow(r, nc));
            // assume number of columns is the
            // same for each row
        }

        return s + "</table>";
    }


    /**
     * getSheet    Method

     * @return     String
     */

    public static String getSheet(String a[]) {
        String s = "";

        for (int i = 0; i < a.length; i++) {
            s = s + "<tr>" + getTd(a[i]) + "</tr>\n";
        }

        return s;
    }


    /**
     * getSheet    Method
     *
     * @return     String
     */

    public static String getSheet(String a[][]) {
        String s = "";

        for (int i = 0; i < a.length; i++) {
            s = s + "<tr>";

            for (int j = 0; j < a[i].length; j++) {
                s = s + getTd(a[i][j]);
            }

            s = s + "</tr>\n";
        }

        return s;
    }


    /**
     * getRow      Method
     *
     * @return     String
     */

    public static String getRow(String s) {
        return "\n <tr>" + s + "</tr>";

    }


    /**
     * getRow      Method
     *
     * @return     String
     */

    public static String getRow(String s, String align) {
        return "\n <tr align=" + quote(align) + ">" + s + "</tr>";

    }


    /**
     * getRow      Method

     * @return     String
     */

    public static String getRow(int r, int nc) {
        String s = "";

        for (int c = 1; c <= nc; c++)
            s = s + getTd(r + "," + c + " ");

        return s;

    }


    /**
     * getTr       Method
     *
     * @return     String
     */

    public static String getTr(String s) {
        return "<tr>" + s + "</tr>\n";
    }


    /**
     * getTd       Method
     *
     * @return     String
     */

    public static String getTd(int w, int h, String s) {
        return "\n\t<td width=\""
                + w
                + "\" height=\"" + h + "\">"
                + s +
                "</td>\n";
    }


    /**
     * getTd       Method
     *
     * @return     String
     */

    public static String getTd(String s, String colSpan) {
        return "\n\t<td colspan=" + quote(colSpan) + ">"
                + s +
                "</td>\n";
    }


    /**
     * getTd       Method
     * @return     String
     */

    public static String getTd(String s) {
        return "\n\t<td>"
                + s +
                "</td>\n";
    }


    /**
     * getTd       Method
     *
     * @parm       String[]       data array
     * @return     String
     */

    public static String getTd(String[] s) {
        String str = "";

        for (int i = 0; i < s.length; i++) {
            str = str + getTd(s[i]);
        }

        return str;
    }


    /**
     * getInput    Method
     *
     * @parm       String      type
     * @parm       String      name
     * @parm       String      value
     * @parm       int         size
     * @return     String
     */

    public static String getInput(String type, String name,
                                  String value, int size) {
        return
                "\n<input type=" + quote(type)
                + "name=" + quote(name)
                + " value=" + quote(value)
                + "size=" + size
                + ">\n";
    }


    /**
     * getInput    Method
     *
     * @parm       String      type
     * @parm       String      name
     * @parm       int         size
     * @return     String
     */

    public static String getInput(String type, String name, String value) {
        return
                "\n<input type=" + quote(type)
                + "name=" + quote(name)
                + " value=" + quote(value)
                + ">";
    }

    /**
     * getInput    Method
     *
     * @parm       String      type
     * @parm       String      name
     * @parm       int         size
     * @return     String
     */

    public static String getInput(String type, String name, String value,
                                  String event, String eventAction) {
        return
                "\n<input type=" + quote(type)
                + " " + "name=" + quote(name)
                + " " + "value=" + quote(value)
                + " " + event + "=" + quote(eventAction)
                + ">";
    }

    /**
     * getTextField Method
     *
     * @parm        String         name
     * @return      String
     */
    public static String getTextField(String name) {

        return getTextField(name, "", 30);
    }


    /**
     * getTextField Method
     *
     * @parm        String         name
     * @parm        String         value
     * @return      String
     */

    public static String getTextField(String name, String value) {

        return getTextField(name, value, 30);
    }

    /**
     * getTextField Method
     *
     * @parm        String         name
     * @parm        String         value
     * @parm        int            size
     * @return      String
     */


    public static String getTextField(String name, String value, int size) {

        return getInput("text", name, value, size);
    }

    /**
     * getPassField Method
     *
     * @parm        String         name
     * @return      String
     */

    public static String getPassField(String name) {

        return getPassField(name, "", 30);
    }


    /**
     * getPassField Method
     *
     * @parm        String         name
     * @parm        String         value
     * @return      String
     */

    public static String getPassField(String name, String value) {

        return getPassField(name, value, 30);
    }

    /**
     * getPassField Method
     *
     * @parm        String         name
     * @parm        String         value
     * @parm        int            size
     * @return      String
     */

    public static String getPassField(String name, String value, int size) {

        return getInput("password", name, value, size);
    }


    /**
     * getHiddenField Method
     *
     * @parm        String         name
     * @parm        String         value
     * @return      String
     */

    public static String getHiddenField(String name, String value) {

        return getInput("Hidden", name, value);
    }


    /**
     * getSelect   Method
     *
     * @parm       String      name
     * @return     String
     */

    public static String getSelect(String name) {
        return "\n\t" + "<Select "
                + "name=" + quote(name)
                + ">";
    }


    /**
     * getOption   Method
     *
     * @parm       String      value
     * @return     String
     */

    public static String getOption(String value) {
        return "\n\t\t" + "<Option "
                + "Value=" + quote(value)
                + ">" + value +
// deh 10/17/01 - added the closing tag for the option html tag
                "</Option>";
    }


    /**
     * getRadio    Method
     *
     * @parm       String      name
     * @parm       String      value
     * @return     String
     */

    public static String getRadio(String name, String value) {

        return getInput("radio", name, value) + value;
    }


    /**
     * getRadioButtons     Method
     *
     * @parm               String      name
     * @parm               int         no of buttons
     * @return             String
     */

    public static String getRadioButtons(String name, int b) {
        String s = "";

        for (int i = 1; i <= b; i++)
            s = s + getRadio(name, i + "");

        return s;
    }


    /**
     * getComboBox Method
     * @author    Dawn Hallaman
     *
     * @parm       String      name
     * @parm       int         value
     * @parm       String      value
     * @return     String
     */

    public static String getComboBox(String name, int value, String str) {

        String s = "" + getSelect(name);

        for (int i = 1; i <= value; i++) {
            s = s + getOption(i + "");
        }

// Gets the final option
// deh - 10/17/01 added the closing /select tag to fix bug

        s = s + getOption(str + "") + "\n\t</Select>";
        return s;
    }


    /**
     * getComboBox Method
     *
     * @parm       String      name
     * @parm       String[]    value
     * @return     String
     */

    public static String getComboBox(String name, String[] value) {

        String s = "" + getSelect(name);

        for (int i = 0; i < value.length; i++) {
            s = s + getOption(value[i] + "");
        }

        s = s + "\n\t</Select>";

        return s;
    }

    /**
     * getCommandButton Method
     *
     * @return          String
     */

    public static String getCommandButton(String name, String value,
                                          String event, String eventAction) {

        return getInput("Button", name, value, event, eventAction);
    }


    /**
     * getSubmitButton Method
     *
     * @return         String
     */

    public static String getSubmitButton() {

        return getInput("Submit", "Submit", "Submit");
    }

    /**
     * getSubmitButton Method
     *
     * @return         String
     */

    public static String getSubmitButton(String name) {

        return getInput("Submit", name, name);
    }

    /**
     * getResetButton Method
     *
     * @return        String
     */

    public static String getResetButton() {

        return getInput("Reset", "Reset", "Reset");
    }

    /**
     * getListItem Method
     *
     * @parm       String     data
     * @return     String
     */

    public static String getListItem(String s) {

        return "<li>\n" + s + "\n</li>";
    }


    /**
     * getBreak    Method
     *
     * @return     String
     */

    public static String getBreak() {

        return "\n<br>\n ";
    }


    /**
     * getBold     Method
     *
     * @return     String
     */

    public static String getBold(String s) {

        return "<b>" + s + "</b>";
    }

    /**
     * getUnderline Method
     *
     * @return      String
     */

    public static String getUnderline(String s) {

        return "<u>" + s + "</u>";
    }

    /**
     * getCenter   Method
     *
     * @return     String
     */

    public static String getCenter(String s) {

        return "<center>" + s + "</center>";
    }


    /**
     * getP        Method
     *
     * @parm       String     data
     * @return     String
     */

    public static String getP(String s) {

        return "<p>\n" + s + "\n</p>";
    }

    /**
     * quote        Method
     *
     * @parm        String         data
     * @return      String
     */

    public static String quote(String s) {

        return '\"' + s + "\" ";
    }

    /**
     * getFont      Method
     *
     * @parm        String         data
     * @parm        String         size
     * @return      String
     */

    public static String getFont(String s, String size) {

        return "<font " + "size = " + size + ">"
                + s
                + "</font>";
    }

    /**
     * getImage     Method
     *
     * @parm        String         source
     * @parm        String         align
     * @return      String
     */

    public static String getImage(String s, String align) {

        return "<image "
                + " src = " + s
                + " align = " + align
                + ">";
    }

    /**
     * getScript    Method
     *
     * @parm        String         lang
     * @return      String
     */

    public static String getScript(String lang) {

        return "<script "
                + " language = " + quote(lang)
                + ">"
                + "\n"
                + "</script>";
    }


    public static String singleQuote(String s) {

        return "'" + s + "'";
    }

}
