package net.server.servlets;

/**
 *  FormCDataColumns Inteface
 */

public interface FormCDataColumns {

    /**
     * CSV File Columns
     */

    static final int COURSE_NO = 1;
    static final int SECTION = 2;
    static final int TERM = 4;
    static final int YEAR = 5;
    static final int COURSE_NAME = 7;
    static final int INSTR = 8;
    static final int INSTR_NAME = 9;
    static final int STUDENT_ID = 12;
    static final int FIRST_NAME = 15;
    static final int MIDDLE_NAME = 16;
    static final int LAST_NAME = 17;


    /**
     * Selected fields order from CSV File
     */

    static final int IND_TERM = 0;
    static final int IND_COURSE_NO = 1;
    static final int IND_COURSE_NAME = 2;
    static final int IND_SECTION = 3;
    static final int IND_YEAR = 4;
    static final int IND_INSTR = 5;
    static final int IND_INSTR_NAME = 6;
    static final int IND_STUDENT_ID = 7;
    static final int IND_FIRST_NAME = 8;
    static final int IND_MIDDLE_NAME = 9;
    static final int IND_LAST_NAME = 10;

    /**
     * Course Key array column order
     */

    static final int COURSE_KEY = 0;
    static final int COURSE_KEY_TERM = 1;
    static final int COURSE_KEY_COURSE_NO = 2;
    static final int COURSE_KEY_COURSE_NAME = 3;
    static final int COURSE_KEY_SECTION = 4;
    static final int COURSE_KEY_YEAR = 5;
    static final int COURSE_KEY_INSTR = 6;

    /**
     * Students array column order
     */

    static final int S_STUDENT_ID = 0;
    static final int S_STUDENT_NAME = 1;

    static final int STUDENTS_ARRAY_SIZE = 2;
    static final int COURSE_KEY_ARRAY_SIZE = 7;

    /**
     * Column order for Line Consumer
     */

    static final int columnOrder[] = {TERM,
                                      COURSE_NO,
                                      COURSE_NAME,
                                      SECTION,
                                      YEAR,
                                      INSTR,
                                      INSTR_NAME,
                                      STUDENT_ID,
                                      FIRST_NAME,
                                      MIDDLE_NAME,
                                      LAST_NAME};


}
