package net.server.servlets;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

/**
 * FormCData	Class
 */

public class FormCData {

    private FormCHtml fch = new FormCHtml();
    private FormCDataParser fc;

    private String formActionURL;

    private int errorCode;
    private String fieldNames[];
    private String fieldValues[];

    private Properties fileProp;
    static final String FORMC_PROPERTY_FILE = Globals.FORMC_PROPERTY_FILE;

    private static final int ERROR_PROPERTY_FILE = 0;
    private static final int ERROR_CSV_FILE = 1;
    private static final int ERROR_UNKNOWN = 2;
    private static final int ERROR_SELECTION = 3;

    /**
     * Initializes the FormC Data elements
     *
     * @return        boolean
     */

    public boolean init() {

        try {
            fileProp = FileUtil.loadProperties(FORMC_PROPERTY_FILE);
            String fn = fileProp.getProperty("FileName");

            System.out.println("The fileName is " + fn);

            File file = FileUtil.getFile(fileProp.getProperty("FileName"));

            formActionURL = fileProp.getProperty("FormCURL");
            fc = new FormCDataParser(FileUtil.openInputFile(file));
            return true;
        } catch (PropFileException pfnf) {
            errorCode = ERROR_PROPERTY_FILE;
            return false;
        } catch (FileNotFoundException fnf) {
            errorCode = ERROR_CSV_FILE;
            return false;
        } catch (IOException io) {
            errorCode = ERROR_UNKNOWN;
            return false;
        }
    }

    /**
     * Course, Section and Term are displayed for the user logged in.
     *
     * @return        String		    html
     */

    public String getDefaultFormC(String user) {


//deh was here and added newcode get multiple courses to show up on the comboxes.. yeah
//

        if (fc.isCourseKeyByLoginUser(user)) {

//  Get the scoop on the indexarray of courses and how many before procedding

            int[] keyIndexArray = fc.getCourseKeyIndexArray();
            int cKeyIndexLength = fc.getCourseKeyIndexLength();


            String[] selCourse = new String[cKeyIndexLength + 1];

            for (int i = 0; i <= cKeyIndexLength; i++) {
                selCourse[i] = fc.getCourseNoByKey(keyIndexArray[i]) + " " +
                        fc.getCourseNameByKey(keyIndexArray[i]);
            }


            return (fch.formCSelect(fc.getTerm(), selCourse,
                    fc.getSection(), formActionURL));


        }

        return (fch.formCError(ERROR_SELECTION));
    }


    /**
     * If no students are available for the selection criteria, error message
     * will be displayed.
     *
     * @return        String		    html
     */

    public String getErrorFormC() {

        return (fch.formCError(errorCode));

    }

    /**
     * Form C will be displayed for the selected Term, Course and Section.
     *
     * @return           String		    html
     */

    public String getSelectFormC(String selTerm, String selCourse,
                                 String selSection) {

        StringBuffer selection = new StringBuffer();

        selection.append(selTerm);
        selection.append(" ");
        selection.append(selCourse);
        selection.append(" ");
        selection.append(selSection);

        String selInstructor = null;
        String selStudents[] = null;

        if (fc.isCourseKey(selection.toString())) {
            int keyIndex = fc.getCourseKeyIndex();
            selInstructor = fc.getCourseInstructorByKey(keyIndex);
            selStudents = fc.getCourseStudentsByKey(keyIndex);

            return (fch.formC(selTerm, selCourse, selInstructor,
                    selStudents, formActionURL));
        } else {

            return (fch.formCError(ERROR_SELECTION));
        }

    }


    /**
     * Form C selections are redisplayed for the confirmation.
     *
     *
     * @return        String		    html
     */

    public String getDisplayFormC(String[] fNames,
                                  String[] fValues) {

        int keyIndex = fc.getCourseKeyIndex();

        fieldNames = new String[fNames.length];

        for (int i = 0; i < fNames.length; i++) {
            fieldNames[i] = fNames[i];
        }

        fieldValues = new String[fValues.length];

        for (int i = 0; i < fValues.length; i++) {
            fieldValues[i] = fValues[i];
        }

        return (fch.formCData(fc.getCourseTermByKey(keyIndex),
                fc.getCourseNoByKey(keyIndex) + " " +
                fc.getCourseNameByKey(keyIndex),
                fc.getCourseInstructorByKey(keyIndex),
                fc.getCourseStudentsByKey(keyIndex),
                fieldNames,
                fieldValues));


    }

    /**
     * Creates a outfile for the SQL insert statement and post confirmation
     * page will be displayed.
     *
     * @return        String		    html
     */

    public String getSqlFormC() {

        FormCSQL fcSql = new FormCSQL(fc);
        fcSql.generateFormCSQL(fieldNames, fieldValues);
        return (fch.formCUpdate());
    }
}
