package net.server.servlets;

import java.io.*;
import java.util.Properties;


/**
 *  File Utility Class
 */

public class FileUtil {


    /**
     * FileUtil() Constructor
     *
     * Don't let anyone instantiate this class
     */

    private FileUtil() {
    }


    /**
     * Returns an instance of a File
     *
     * @return        File
     */

    public static File getFile(String f) {

        return new File(f);
    }


    /**
     * Returns an instance of a Property
     * @return        Properties
     */

    public static Properties loadProperties(String f)
            throws PropFileException {
        Properties prop = new Properties();

        try {
            FileInputStream fs = getFileInputStream(f);
            prop.load(fs);
            fs.close();
        } catch (FileNotFoundException pfnf) {
            throw new PropFileException();
        } catch (IOException io) {
            throw new PropFileException();
        }

        return prop;
    }


    /**
     * Returns an instance of a FileInputStream
     *
     * @return        FileInputStream
     */

    public static FileInputStream getFileInputStream(String f)
            throws FileNotFoundException, IOException {

        return new FileInputStream(f);
    }


    /**
     * Returns an instance of a BufferedReader
     *
     * @return        BufferedReader
     */

    public static BufferedReader openInputFile(File f)
            throws FileNotFoundException, IOException {

        return (new BufferedReader(new FileReader(f)));
    }


    /**
     * Returns an instance of a BufferedWriter
     * @return        BufferedWriter
     */

    public static BufferedWriter openOutputFile(File f)
            throws FileNotFoundException, IOException {

        return (new BufferedWriter(new FileWriter(f)));
    }


    /**
     * Closes the BufferedReader
     *
     */

    public static void close(BufferedReader br) {

        try {
            br.close();
        } catch (IOException io) {
        }

    }


    /**
     * Closes the BufferedWriter
     *
     */

    public static void close(BufferedWriter bw) {

        try {
            bw.close();
        } catch (IOException io) {
        }

    }

    /**
     * println() Method
     *
     * Appends the object to the BufferedWriter
     *
     */

    public static void println(BufferedWriter bw, Object o) {

        try {
            bw.write(o + "\n");
        } catch (IOException io) {
        }

    }

}
