/* Remote Server*/


package net.rmi.rmiimage;


import java.rmi.RMISecurityManager;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;


public class Server

    extends UnicastRemoteObject

    implements BenchMark {

  private String name;


  public Server(String s)

      throws RemoteException {

    super();

    name = s;

  }


  public void multiplyBench(long range)

      throws RemoteException {

    long i, product;

    int d1, d2;

    d1 = 2;

    d2 = 3;

    for (i = 0; i < range; i++)

      product = d1 * d2;

  }


  public static void run() {

    String args[] = {""};

    main(args);

  }

  public static void main(String args[]) {

    System.setSecurityManager(new RMISecurityManager());

    Registry r = null;

    try {

      Server obj = new Server("HelloServer");

      try {

        r = LocateRegistry.createRegistry(1099);

      } catch (Exception e) {

        System.out.println(e);
      }

      try {

        r.rebind("HelloServer", obj);

      } catch (Exception e) {

        System.out.println(e);
      }


      System.out.println("HelloServer bound in registry");

    } catch (Exception e) {

      System.out.println("Server err: " + e.getMessage());

      e.printStackTrace();

    }

  }

}













