/**
 * Class LexType - return type of a method or type of a field
 */

package net.rmi.rmiSynth.lex;

public class LexType {
  private String name;
  private boolean array;

  /**
   * Constructor
   */
  public LexType() {
    name = "";
    array = false;
  }

  /**
   * Gets name of structure
   * @param _name New name
   */
  public void setName(String _name) {
    name = _name;
  }

  /**
   * Sets name of structure
   * @return name Type name
   */
  public String getName() {
    return name;
  }

  /**
   * Sets type as array
   * @param _array true if array, false if not
   */
  public void setArray(boolean _array) {
    array = _array;
  }

  /**
   * If type is array
   * @return array true if array, false if not
   */
  public boolean isArray() {
    return array;
  }

  /**
   * If method returns void
   * @return (true or false)
   */
  public boolean isVoid() {
    return name.equals("void") ? true : false;
  }

  /**
   * To string
   * @return s
   */
  public String toString() {
    String s = "";
    s = s + name;
    s = s + " ";
    return s;
  }

}
