/**
 * Class LexModif - class, method, or field modifier
 * @author Roman Yedokov
 */

package net.rmi.rmiSynth.lex;

public class LexModif {
  public final int DEFAULT = 0;
  public final int PUBLIC = 1;
  public final int PRIVATE = 2;
  public final int PROTECTED = 3;

  private int visibility;
  private boolean stat;

  /**
   * Constructor
   */
  public LexModif() {
    setVisibility(DEFAULT);
  }

  /**
   * Set visibility
   * @param _visibility default, public, private, or protected
   */
  public void setVisibility(int _visibility) {
    visibility = _visibility;
  }

  /**
   * Get visibility
   * @return visibility default, public, private, or protected
   */
  public int getVisibility() {
    return visibility;
  }

  /**
   * If visivility==0
   * @return true
   * else
   * return false
   */
  public boolean isDefault() {
    return visibility == DEFAULT ? true : false;
  }

  /**
   * If visivility==1
   * @return true
   * else
   * return false
   */
  public boolean isPublic() {
    return visibility == PUBLIC ? true : false;
  }

  /**
   * If visivility==2
   * @return true
   * else
   * return false
   */
  public boolean isPrivate() {
    return visibility == PRIVATE ? true : false;
  }

  /**
   * If visivility==3
   * @return true
   * else
   * return false
   */
  public boolean isProtected() {
    return visibility == PROTECTED ? true : false;
  }

  /**
   * Set static
   * @param _static true or false
   */
  public void setStatic(boolean _stat) {
    stat = _stat;
  }

  /**
   * If static
   * @return stat
   */
  public boolean isStatic() {
    return stat;
  }

  /**
   * Returns structure visibility
   * 0-""
   * 1-public
   * 2-private
   * 3-protected
   */
  public String visibilityToString() {
    String s;
    switch (visibility) {
      case PUBLIC:
        s = "public ";
        break;
      case PRIVATE:
        s = "private ";
        break;
      case PROTECTED:
        s = "protected ";
        break;
      default:
        s = "";
        break;
    }
    return s;
  }

  /**
   * Staticity to string
   * @return "static" or empty string
   */
  public String statToString() {
    return isStatic() ? "static " : "";
  }

  /**
   * Modifier to string
   */
  public String toString() {
    return visibilityToString() + statToString();
  }
}
