/**
 * Class LexBody - body(code) of a method
 * @author Roman Yedokov
 * { object.method }
 */

package net.rmi.rmiSynth.lex;


public class LexBody extends LexStructure {
  private String delegObj;		//Delegate object
  private boolean ret;			//If returns
  private String code;
  private boolean tryCatch;

  /**
   * Constructor
   */
  public LexBody() {
    delegObj = "";
    code = "";
    tryCatch = false;
  }

  /**
   * Gets cutils.delegate object
   * @return delegObg
   */
  public String getDelegObj() {
    return delegObj;
  }

  /**
   * Sets cutils.delegate object
   * @param _delegObg Delegate object
   */
  public void setDelegObj(String _delegObj) {
    this.delegObj = _delegObj;
  }

  /**
   * If object is not empty returns it with dot
   * Otherwise returns empty string
   * @ return s
   */
  public String doToString() {
    String s = "";
    if (!delegObj.equals("")) {
      s = delegObj + ".";
    }
    return s;
  }


  /**
   * Gets code
   * @return code
   */
  public String getCode() {
    return code;
  }

  /**
   * Sets code
   * @param _code Code
   */
  public void setCode(String _code) {
    this.code = _code;
  }

  /**
   * Sets try-catch block
   * @param _tryCatch Try-catch block
   */
  public void setTryCatch(boolean _tryCatch) {
    tryCatch = _tryCatch;
  }

  /**
   * If try-catch block has bben set
   * @return tryCatch
   */
  public boolean isTryCatch() {
    return tryCatch;
  }

  /**
   * Set return
   * @param _ret Return
   */
  public void setRet(boolean _ret) {
    ret = _ret;
  }

  /**
   * If method returns something
   * @return ret
   */
  public boolean isRet() {
    return ret;
  }

  /**
   * Return to string
   * @return return or ""
   */
  public String retToString() {
    return ret ? "return " : "";
  }

  /**
   * LexBody to string
   * @return s
   */
  public String toString() {
    String s = "";
    s = s + (isTryCatch() ? "try {\n" : "");
    s = s + retToString();
    s = s + doToString();
    s = s + getName();
    s = s + (isTryCatch() ? "\t\t} catch  (Exception e) {e.printStackTrace();}\n" : "");
    return s;
  }

  /**
   * Code to string
   * @return s
   */
  public String codeToString() {
    String s = "";
    s = s + (isTryCatch() ? "try {\n" : "");
    s = s + code;
    s = s + (isTryCatch() ? "\t\t} catch  (Exception e) {e.printStackTrace();}\n" : "");
    return s;
  }
}
